/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.common.collect;

import com.oceanbase.obtools.common.collect.BaseOperator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public final class Lists
extends BaseOperator {
    private Lists() {
    }

    @SafeVarargs
    public static <E> ArrayList<E> newArrayList(E ... elements) {
        Lists.checkNotNull(elements);
        int capacity = Lists.computeArrayListCapacity(elements.length);
        ArrayList list = new ArrayList(capacity);
        Collections.addAll(list, elements);
        return list;
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        Lists.checkNotNull(elements);
        return elements instanceof Collection ? new ArrayList<E>(Lists.cast(elements)) : Lists.newArrayList(elements.iterator());
    }

    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        ArrayList<Object> list = Lists.newArrayList(new Object[0]);
        Lists.addAll(list, elements);
        return list;
    }
}

