/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.common.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final boolean daemon;
    private final int priority;
    private final Thread.UncaughtExceptionHandler handler;
    private final AtomicInteger sequence = new AtomicInteger(0);

    public NamedThreadFactory(String prefix) {
        this(prefix, false, 5, null);
    }

    public NamedThreadFactory(String prefix, boolean daemon, int priority, Thread.UncaughtExceptionHandler handler) {
        this.prefix = prefix;
        this.daemon = daemon;
        this.priority = priority;
        this.handler = handler;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(r);
        thread.setDaemon(this.daemon);
        thread.setName(this.prefix + this.sequence.getAndIncrement());
        thread.setPriority(this.priority);
        if (this.handler != null) {
            thread.setUncaughtExceptionHandler(this.handler);
        }
        return thread;
    }
}

