/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.common.pool.string;

import java.util.Objects;

public class DynamicString
implements AutoCloseable {
    private final StringBuilder sb;

    public DynamicString() {
        this.sb = new StringBuilder(16);
    }

    public DynamicString(int capacity) {
        this.sb = new StringBuilder(capacity);
    }

    public DynamicString append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public DynamicString append(String str) {
        this.sb.append(str);
        return this;
    }

    public DynamicString append(StringBuffer sb) {
        this.sb.append(sb);
        return this;
    }

    public DynamicString append(CharSequence s) {
        this.sb.append(s);
        return this;
    }

    public DynamicString append(CharSequence s, int start, int end) {
        this.sb.append(s, start, end);
        return this;
    }

    public DynamicString append(char[] str) {
        this.sb.append(str);
        return this;
    }

    public DynamicString append(char[] str, int offset, int len) {
        this.sb.append(str, offset, len);
        return this;
    }

    public DynamicString append(boolean b) {
        this.sb.append(b);
        return this;
    }

    public DynamicString append(char c) {
        this.sb.append(c);
        return this;
    }

    public DynamicString append(int i) {
        this.sb.append(i);
        return this;
    }

    public DynamicString append(long lng) {
        this.sb.append(lng);
        return this;
    }

    public DynamicString append(float f) {
        this.sb.append(f);
        return this;
    }

    public DynamicString append(double d) {
        this.sb.append(d);
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.sb);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicString)) {
            return false;
        }
        DynamicString other = (DynamicString)obj;
        return Objects.deepEquals(this.sb, other.sb);
    }

    @Override
    public void close() throws Exception {
        this.sb.setLength(0);
    }
}

