/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.common.utils;

import java.util.Collection;
import java.util.Locale;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean containsIgnoreCase(Collection<String> collection, String obj) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        if (obj == null) {
            return collection.contains(obj);
        }
        return collection.contains(obj) || collection.contains(obj.toUpperCase(Locale.getDefault())) || collection.contains(obj.toLowerCase(Locale.getDefault()));
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T> void addIgnoreNull(Collection<T> collection, T object) {
        if (object == null) {
            return;
        }
        collection.add(object);
    }

    public static <T> void addAllIgnoreNull(Collection<T> collection, Collection<T> sub) {
        if (CollectionUtils.isEmpty(sub)) {
            return;
        }
        for (T t : sub) {
            if (t == null) continue;
            collection.add(t);
        }
    }
}

