/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.common.utils;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StringUtils {
    public static final String EMPTY = "";
    public static final String BLANK = " ";

    private StringUtils() {
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        return cs1.toString().equals(cs2.toString());
    }

    public static boolean notEquals(CharSequence cs1, CharSequence cs2) {
        return !StringUtils.equals(cs1, cs2);
    }

    public static boolean equalsIgnoreCase(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        return cs1.toString().equalsIgnoreCase(cs2.toString());
    }

    public static boolean notEqualsIgnoreCase(CharSequence cs1, CharSequence cs2) {
        return !StringUtils.equalsIgnoreCase(cs1, cs2);
    }

    public static Set<String> split(String str, String splitStr) {
        if (str == null) {
            return null;
        }
        if (splitStr == null || !str.contains(splitStr)) {
            return Sets.newHashSet(str);
        }
        return Arrays.stream(str.split(splitStr)).map(e -> e.trim()).collect(Collectors.toSet());
    }

    public static List<String> splitKeepOrder(String str, String splitStr) {
        if (str == null) {
            return null;
        }
        if (splitStr == null || !str.contains(splitStr)) {
            return Lists.newArrayList(str);
        }
        return Arrays.stream(str.split(splitStr)).map(String::trim).collect(Collectors.toList());
    }

    public static boolean contains(String input, String search) {
        if (input == null || search == null) {
            return false;
        }
        return input.contains(search);
    }

    public static int countMatches(CharSequence str, char ch) {
        if (StringUtils.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (ch != str.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String join(String[] array, String separator) {
        if (array == null) {
            return null;
        }
        return Stream.of(array).filter(e -> e != null).map(e -> e.trim()).collect(Collectors.joining(separator));
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        return Stream.of(array).filter(e -> e != null).map(e -> String.valueOf(e)).collect(Collectors.joining(String.valueOf(separator)));
    }

    public static String replaceAll(String input, String regex, String replacement) {
        if (input == null) {
            return null;
        }
        return input.replaceAll(regex, replacement);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return StringUtils.startsWith(str, prefix, true);
    }

    private static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return StringUtils.endsWith(str, suffix, true);
    }

    private static boolean endsWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == suffix;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return StringUtils.regionMatches(str, ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length() - start;
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (srcLen < length || otherLen < length) {
            return false;
        }
        while (tmpLen-- > 0) {
            char u2;
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            char u1 = Character.toUpperCase(c1);
            if (u1 == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isContainLowerCase(String str) {
        if (str == null || StringUtils.isEmpty(str)) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainUpperCase(String str) {
        if (str == null || StringUtils.isEmpty(str)) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String matchStr(String str, String regex, int group) {
        Matcher matcher = Pattern.compile(regex).matcher(str);
        if (!matcher.find()) {
            throw new IllegalArgumentException(String.format("Cannot use %s to match a string in %s", regex, str));
        }
        return matcher.group(group);
    }

    public static String substringFirstScope(String str, String symbol) {
        int startIndex = str.indexOf(symbol) + symbol.length();
        int endIndex = str.indexOf(symbol, startIndex);
        return str.substring(startIndex, endIndex);
    }
}

