/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.cache;

import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.calculator.model.TableEntryKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObTableCache {
    private static final Logger log = LoggerFactory.getLogger(ObTableCache.class);
    private static final ObTableCache INSTANCE = new ObTableCache();
    private final Map<TableEntryKey, TableEntry> cache;
    private final ReentrantLock lock = new ReentrantLock();

    private ObTableCache() {
        this.cache = new ConcurrentHashMap<TableEntryKey, TableEntry>();
    }

    public static ObTableCache getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.getCache().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableEntry addTableEntry(TableEntry entry) {
        if (entry == null) {
            log.error("Null table entry: {}", (Object)entry);
            return null;
        }
        if (!entry.isValid()) {
            log.error("Invalid table entry: {}", (Object)entry);
            return null;
        }
        this.lock.lock();
        try {
            TableEntry exists = this.getCache().put(entry.getTableEntryKey(), entry);
            if (exists != null) {
                exists.setDeletedState();
            }
            TableEntry tableEntry = exists;
            return tableEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableEntry removeTableEntry(TableEntryKey key) {
        if (key == null || !key.isValid()) {
            log.error("Invalid table entry key: {}", (Object)key);
            return null;
        }
        this.lock.lock();
        try {
            TableEntry deleted = this.getCache().remove(key);
            if (deleted != null) {
                deleted.setDeletedState();
            }
            TableEntry tableEntry = deleted;
            return tableEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableEntry getTableEntry(TableEntryKey key) {
        if (key == null) {
            log.error("Null table entry key: {}", (Object)key);
            return null;
        }
        if (!key.isValid()) {
            log.error("Invalid table entry key: {}", (Object)key);
            return null;
        }
        TableEntry cachedTableEntry = this.getCache().get(key);
        if (cachedTableEntry != null) {
            return cachedTableEntry;
        }
        this.lock.lock();
        try {
            cachedTableEntry = this.getCache().get(key);
            if (cachedTableEntry == null) {
                TableEntry buildingEntry = TableEntry.allocBuildingEntry(key);
                this.addTableEntry(buildingEntry);
                cachedTableEntry = this.getCache().get(key);
                if (!cachedTableEntry.isBuildingState() || buildingEntry != cachedTableEntry) {
                    log.error("Can not found the added building state table entry, key: {}", (Object)key);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return cachedTableEntry;
    }

    public Map<TableEntryKey, TableEntry> getCache() {
        return this.cache;
    }
}

