/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.constants;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class Constants {
    public static final String EMPTY_STRING = "";
    public static final String BLANK_STRING = " ";
    public static final int PART_ID_BITNUM = 28;
    public static final int PART_ID_SHIFT = 32;
    public static final String VIRTUAL_IP = "0.0.0.0";
    public static final long VIRTUAL_PORT = 0L;
    public static final long ZERO_PARTITION = 0L;
    public static final long MAX_PART_NUM = 64L;
    public static final String SYS_TENANT = "sys";
    public static final String OCEANBASE_DATABASE = "oceanbase";
    public static final String ALL_DUMMY_TABLE = "__all_dummy";
    public static final int SSSTORE_BITS_SHIFT = 2;
    public static final int CLOG_BITS_SHIFT = 4;
    public static final int WITH_MEMSTORE = 0;
    public static final int WITHOUT_MEMSTORE = 1;
    public static final int WITH_SSSTORE = 0;
    public static final int WITHOUT_SSSTORE = 4;
    public static final int SYNC_CLOG = 0;
    public static final int ASYNC_CLOG = 16;
    public static final BigInteger INT_MOD_VALUE = BigInteger.valueOf(0x80000000L);
    public static final long UNSIGNED_INT_MOD_VALUE = 0x100000000L;
    public static final BigInteger BIGINTEGER_ZERO = BigInteger.ZERO;
    public static final BigInteger BIGINTEGER_3 = BigInteger.valueOf(3L);
    public static final BigInteger BIGINTEGER_FF = BigInteger.valueOf(255L);
    public static final BigInteger BIGINTEGER_FFFF = BigInteger.valueOf(65535L);
    public static final BigInteger BIGINTEGER_63 = BigInteger.valueOf(63L);
    public static final BigInteger BIGINT_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger BIGINTEGER_MOD_VALUE = new BigInteger("18446744073709551616");
    public static final BigInteger BIGINTEGER_OB_CS_REPLACEMENT_CHARACTER = BigInteger.valueOf(65533L);
    @Deprecated
    public static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    @Deprecated
    public static final BigInteger LONG_MOD_VALUE = new BigInteger("18446744073709551616");
    public static final BigInteger HASH_SEED_VALUE = new BigInteger("14313749767032793493");
    public static final BigInteger BIGINTEGER_HASH_SEED = BigInteger.valueOf(3782874213L);
    public static final Pattern IP_PATTERN = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
    public static final String[] DEFAULT_PARSE_PATTERNS = new String[]{"yyyyMMdd", "yyyyMMddHHmmss", "yyyyMMddHHmmssSSS", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss.SSS"};
    public static Map<String, String> formatMap = new HashMap<String, String>();

    static {
        formatMap.put("SYYYYMM", "yyyyMM");
        formatMap.put("SYYYY-MM", "yyyy-MM");
        formatMap.put("SYYYY/MM", "yyyy/MM");
        formatMap.put("YYYYMM", "yyyyMM");
        formatMap.put("YYYY-MM", "yyyy-MM");
        formatMap.put("YYYY/MM", "yyyy/MM");
        formatMap.put("SYYYYMMDD", "yyyyMMdd");
        formatMap.put("SYYYY-MM-DD", "yyyy-MM-dd");
        formatMap.put("SYYYY/MM/DD", "yyyy/MM/dd");
        formatMap.put("YYYYMMDD", "yyyyMMdd");
        formatMap.put("YYYY-MM-DD", "yyyy-MM-dd");
        formatMap.put("YYYY/MM/DD", "yyyy/MM/dd");
        formatMap.put("SYYYY-MM-DD HH24:MI:SS", "yyyy-MM-dd HH:mm:ss");
        formatMap.put("SYYYY/MM/DD HH24:MI:SS", "yyyy/MM/dd HH:mm:ss");
        formatMap.put("YYYY-MM-DD HH24:MI:SS", "yyyy-MM-dd HH:mm:ss");
        formatMap.put("YYYY/MM/DD HH24:MI:SS", "yyyy/MM/dd HH:mm:ss");
        formatMap.put("SYYYY-MM-DD HH:MI:SS", "yyyy-MM-dd hh:mm:ss");
        formatMap.put("SYYYY/MM/DD HH:MI:SS", "yyyy/MM/dd hh:mm:ss");
        formatMap.put("YYYY-MM-DD HH:MI:SS", "yyyy-MM-dd hh:mm:ss");
        formatMap.put("YYYY/MM/DD HH:MI:SS", "yyyy/MM/dd hh:mm:ss");
        formatMap.put("SYYYY-MM-DD HH12:MI:SS", "yyyy-MM-dd hh:mm:ss");
        formatMap.put("SYYYY/MM/DD HH12:MI:SS", "yyyy/MM/dd hh:mm:ss");
        formatMap.put("YYYY-MM-DD HH12:MI:SS", "yyyy-MM-dd hh:mm:ss");
        formatMap.put("YYYY/MM/DD HH12:MI:SS", "yyyy/MM/dd hh:mm:ss");
        formatMap.put("YYYY-MM-DD HH24:MI:SS.FF", "yyyy-MM-dd HH:mm:ss.SSSSSS");
        formatMap.put("YYYY-MM-DD HH:MI:SS.FF", "yyyy-MM-dd hh:mm:ss.SSSSSS");
        formatMap.put("YYYY-MM-DD HH12:MI:SS.FF", "yyyy-MM-dd HH:mm:ss.SSSSSS");
    }
}

