/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.enums;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public enum ObPartLevel {
    LEVEL_ZERO("LEVEL_ZERO", 0L),
    LEVEL_ONE("LEVEL_ONE", 1L),
    LEVEL_TWO("LEVEL_TWO", 2L),
    UNKNOWN("UNKNOWN", 3L);

    private static final Map<Long, ObPartLevel> INDEX_MAPPING;
    private static final Map<String, ObPartLevel> NAME_MAPPING;
    private String name = "";
    private long index = -1L;

    private ObPartLevel(String name, long index) {
        this.name = name;
        this.index = index;
    }

    public static ObPartLevel getObPartitionLevel(long index) {
        return INDEX_MAPPING.getOrDefault(index, UNKNOWN);
    }

    public static ObPartLevel getObPartitionLevel(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String upper = name.toUpperCase(Locale.getDefault());
        return NAME_MAPPING.getOrDefault(upper, UNKNOWN);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    static {
        INDEX_MAPPING = new HashMap<Long, ObPartLevel>(4);
        NAME_MAPPING = new HashMap<String, ObPartLevel>(4);
        for (ObPartLevel obPartitionLevel : ObPartLevel.values()) {
            NAME_MAPPING.putIfAbsent(obPartitionLevel.getName(), obPartitionLevel);
            INDEX_MAPPING.putIfAbsent(obPartitionLevel.getIndex(), obPartitionLevel);
        }
    }
}

