/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.function.mysql;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.functions.Function;
import com.oceanbase.partition.calculator.utils.CommonUtils;
import java.sql.Date;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public final class ToDays
implements Function {
    public static final ToDays instance = new ToDays();
    private static final LocalDateTime ZERO_DATE_TIME = LocalDateTime.of(0, 1, 1, 0, 0, 0, 0);

    private ToDays() {
    }

    public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
        if (x.getArguments().size() != 1) {
            return SQLEvalVisitor.EVAL_ERROR;
        }
        SQLExpr expr = (SQLExpr)x.getArguments().get(0);
        expr.accept((SQLASTVisitor)visitor);
        Object result = expr.getAttributes().get("eval.value");
        if (result == null) {
            return SQLEvalVisitor.EVAL_ERROR;
        }
        Date date = CommonUtils.toDate(result.toString());
        if (date == null) {
            return null;
        }
        Instant instant = Instant.ofEpochMilli(date.getTime());
        LocalDateTime inputDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        if (inputDateTime.isAfter(ZERO_DATE_TIME)) {
            return null;
        }
        return Duration.between(ZERO_DATE_TIME, inputDateTime).toDays();
    }
}

