/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.function.oracle;

import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.functions.Function;
import com.oceanbase.partition.calculator.constants.Constants;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToTimestamp
implements Function {
    private static final Logger log = LoggerFactory.getLogger(ToTimestamp.class);
    public static final ToTimestamp instance = new ToTimestamp();

    public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
        String format;
        String chars;
        List arguments = x.getArguments();
        if (arguments.size() == 0) {
            return SQLEvalVisitor.EVAL_ERROR;
        }
        if (arguments.size() == 1 && arguments.get(0) instanceof SQLCharExpr) {
            chars = ((SQLCharExpr)arguments.get(0)).getText();
            format = "yyyy-MM-dd HH:mm:ss.SSSSSS";
            try {
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
                return Timestamp.valueOf(LocalDateTime.parse(chars, dateTimeFormatter));
            }
            catch (Exception e) {
                log.error("Parse date format failed. Date : {}, Format : {}. Root reason : {}", new Object[]{chars, format, e.getStackTrace()});
            }
        }
        if (arguments.size() == 2 && arguments.get(0) instanceof SQLCharExpr && arguments.get(1) instanceof SQLCharExpr) {
            chars = ((SQLCharExpr)arguments.get(0)).getText();
            format = ((SQLCharExpr)arguments.get(1)).getText();
            try {
                format = Constants.formatMap.get(format);
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
                return Timestamp.valueOf(LocalDateTime.parse(chars, dateTimeFormatter));
            }
            catch (Exception e) {
                log.error("Parse date format failed. Date : {}, Format : {}. Root reason : {}", new Object[]{chars, format, e.getStackTrace()});
            }
        }
        if (arguments.size() == 3 && arguments.get(0) instanceof SQLCharExpr && arguments.get(1) instanceof SQLCharExpr && arguments.get(2) instanceof SQLCharExpr) {
            chars = ((SQLCharExpr)arguments.get(0)).getText().trim();
            format = ((SQLCharExpr)arguments.get(1)).getText().trim().toUpperCase();
            try {
                format = Constants.formatMap.get(format);
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
                return Timestamp.valueOf(LocalDateTime.parse(chars, dateTimeFormatter));
            }
            catch (Exception e) {
                log.error("Parse date format failed. Date : {}, Format : {}. Root reason : {}", new Object[]{chars, format, e.getStackTrace()});
            }
        }
        return null;
    }
}

