/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.helper;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.partition.calculator.helper.TableEntryHelper;
import com.oceanbase.partition.calculator.helper.TableEntryHelperFor4;
import com.oceanbase.partition.calculator.model.ObReplicaType;
import com.oceanbase.partition.calculator.model.ObServerAddr;
import com.oceanbase.partition.calculator.model.ObServerRole;
import com.oceanbase.partition.calculator.model.PartitionLocation;
import com.oceanbase.partition.calculator.model.ReplicaLocation;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.calculator.model.TableEntryKey;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableEntryExtractor {
    private static final Logger log = LoggerFactory.getLogger(TableEntryExtractor.class);
    final String PROXY_PART_LEADER_LOCATION_SQL = "select svr_ip, sql_port, table_id, table_type, role, partition_id, part_num, replica_num, schema_version, spare1 from oceanbase.__all_virtual_proxy_schema where tenant_name=? and database_name=? and table_name=? and partition_id in ({0}) and role=1 order by role asc";
    private LocationState locationState = new LocationState(false, null);

    public TableEntry queryTableEntry(DruidDataSource ds, TableEntryKey key) throws Exception {
        return this.queryTableEntry(ds, key, false);
    }

    public TableEntry queryTableEntry(DruidDataSource ds, TableEntryKey key, boolean isSubsequentFromV4) throws Exception {
        try (DruidPooledConnection conn = ds.getConnection(60000L);){
            if (isSubsequentFromV4) {
                TableEntry tableEntry = TableEntryHelperFor4.queryTableEntry((Connection)conn, key);
                return tableEntry;
            }
            TableEntry tableEntry = TableEntryHelper.queryTableEntry((Connection)conn, key);
            return tableEntry;
        }
    }

    public TableEntry queryTableEntry(Connection conn, TableEntryKey key, boolean isSubsequentFromV4) throws Exception {
        if (isSubsequentFromV4) {
            return TableEntryHelperFor4.queryTableEntry(conn, key);
        }
        return TableEntryHelper.queryTableEntry(conn, key);
    }

    public Map<Long, String> queryLeaderLocationMap(Connection conn, TableEntry entry, List<Long> partIds) throws Exception {
        return this.queryLeaderLocationMap(conn, entry, partIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Map<Long, String> queryLeaderLocationMap(Connection conn, TableEntry entry, List<Long> partIds, boolean subsequent4) throws Exception {
        Stopwatch clock;
        if (CollectionUtils.isEmpty(partIds)) {
            return new HashMap<Long, String>(0);
        }
        String table = entry.getTableName();
        if (!this.locationState.isInit()) {
            Class<TableEntryExtractor> clazz = TableEntryExtractor.class;
            // MONITORENTER : com.oceanbase.partition.calculator.helper.TableEntryExtractor.class
            if (!this.locationState.isInit()) {
                clock = Stopwatch.createStarted();
                if (TableEntryHelper.isOneUnitWithNonRandomPrimaryZone(conn, entry, subsequent4)) {
                    Map<Long, String> partLeaderMap = TableEntryHelper.queryPartLocationForOneUnit(conn, entry, partIds, subsequent4);
                    this.locationState.setInit(true);
                    if (CollectionUtils.isNotEmpty(partLeaderMap.values())) {
                        this.locationState.setLeader(partLeaderMap.values().iterator().next());
                    }
                    log.info("Query the leader location \"{}\" in one unit finished. Elapsed: {}", (Object)table, (Object)clock);
                    if (partLeaderMap.size() == partIds.size()) {
                        // MONITOREXIT : clazz
                        return partLeaderMap;
                    }
                }
            }
            // MONITOREXIT : clazz
        }
        if (this.locationState.isOneUnitWithNonRandomPrimaryZone()) {
            return partIds.stream().collect(Collectors.toMap(p -> p, p -> this.locationState.getLeader()));
        }
        List partitionedPartitionIds = Lists.newArrayList();
        if (partIds.size() <= 200) {
            partitionedPartitionIds.add(Lists.newArrayList(partIds));
        } else {
            partitionedPartitionIds = Lists.partition((List)Lists.newArrayList(partIds), (int)200);
        }
        clock = Stopwatch.createStarted();
        HashMap<Long, String> partLeaderLocationMap = new HashMap<Long, String>();
        Iterator iterator = partitionedPartitionIds.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                log.info("Query the leader location \"{}\" in multi unit finished. Elapsed: {}", (Object)table, (Object)clock);
                if (!MapUtils.isEmpty(partLeaderLocationMap)) return partLeaderLocationMap;
                throw new IllegalStateException("The leader location of table: \"" + table + "\" is not exists.");
            }
            List partitionIds = (List)iterator.next();
            HashSet partitionIdSet = Sets.newHashSet((Iterable)partitionIds);
            partLeaderLocationMap.putAll(TableEntryHelper.queryPartLocationForMultiUnit(conn, entry, partitionIdSet, subsequent4));
        }
    }

    private List<PartitionLocation> queryPartLocations(Connection conn, TableEntryKey key, String ids) {
        int retryTimes = 0;
        boolean hasValidReplica = false;
        String table = key.getTableName();
        String sql = MessageFormat.format("select svr_ip, sql_port, table_id, table_type, role, partition_id, part_num, replica_num, schema_version, spare1 from oceanbase.__all_virtual_proxy_schema where tenant_name=? and database_name=? and table_name=? and partition_id in ({0}) and role=1 order by role asc", ids);
        ArrayList<PartitionLocation> partitionLocations = new ArrayList<PartitionLocation>();
        while (!hasValidReplica && retryTimes < 5) {
            try {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    pstmt.setString(1, key.getTenantName());
                    pstmt.setString(2, key.getSchemaName());
                    pstmt.setString(3, table);
                    ResultSet rs = pstmt.executeQuery();
                    Throwable throwable2 = null;
                    try {
                        HashMap<Long, PartitionLocation> locationMap = new HashMap<Long, PartitionLocation>();
                        while (rs.next()) {
                            Long partId = rs.getLong("partition_id");
                            PartitionLocation partitionLocation = locationMap.getOrDefault(partId, new PartitionLocation());
                            ReplicaLocation replica = new ReplicaLocation();
                            replica.setRole(ObServerRole.getRole(rs.getInt("role")));
                            replica.setReplicaType(ObReplicaType.getObReplicaType(rs.getInt("spare1")));
                            replica.setAddr(new ObServerAddr(rs.getString("svr_ip"), rs.getLong("sql_port")));
                            if (!replica.isValid()) {
                                log.warn("Ignore the invalid replica: {}, table: {}, part: {}", new Object[]{replica, table, partId});
                                continue;
                            }
                            hasValidReplica = true;
                            partitionLocation.addReplica(replica);
                            partitionLocation.setPartId(partId);
                            partitionLocation.setSchemaVersion(rs.getLong("schema_version"));
                            locationMap.putIfAbsent(partId, partitionLocation);
                        }
                        partitionLocations.addAll(locationMap.values());
                        Thread.sleep((long)(new Random().nextInt(100) + 10) * (2L << ++retryTimes));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
            catch (Exception e) {
                log.warn("Failed to get partition location. table: {}, part: [{}]", new Object[]{table, ids, e});
            }
        }
        if (!hasValidReplica) {
            throw new IllegalStateException("No valid replicas were found after retry " + retryTimes + " times. table: \"" + key.getTableName() + "\", part: [" + ids + "]");
        }
        if (retryTimes > 0) {
            log.debug("Retry {} times to get partition location. Table: {}, Part: [{}]", new Object[]{retryTimes, table, ids});
        }
        return partitionLocations;
    }

    class LocationState {
        private boolean init;
        private String leader;

        public boolean isOneUnitWithNonRandomPrimaryZone() {
            return this.init && StringUtils.isNotBlank((CharSequence)this.leader);
        }

        public boolean isInit() {
            return this.init;
        }

        public String getLeader() {
            return this.leader;
        }

        public void setInit(boolean init) {
            this.init = init;
        }

        public void setLeader(String leader) {
            this.leader = leader;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocationState)) {
                return false;
            }
            LocationState other = (LocationState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isInit() != other.isInit()) {
                return false;
            }
            String this$leader = this.getLeader();
            String other$leader = other.getLeader();
            return !(this$leader == null ? other$leader != null : !this$leader.equals(other$leader));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LocationState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isInit() ? 79 : 97);
            String $leader = this.getLeader();
            result = result * 59 + ($leader == null ? 43 : $leader.hashCode());
            return result;
        }

        public String toString() {
            return "TableEntryExtractor.LocationState(init=" + this.isInit() + ", leader=" + this.getLeader() + ")";
        }

        public LocationState(boolean init, String leader) {
            this.init = init;
            this.leader = leader;
        }
    }
}

