/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.model;

import com.oceanbase.partition.calculator.model.ObRouteEntryState;
import com.oceanbase.partition.calculator.utils.CommonUtils;
import java.util.concurrent.atomic.AtomicReference;

public class ObRouteEntry {
    protected long createTimeUs;
    protected long lastValidTimeUs;
    protected long lastAccessTimeUs;
    protected long lastUpdateTimeUs;
    protected AtomicReference<ObRouteEntryState> state = new AtomicReference();

    public ObRouteEntry() {
        this.state.set(ObRouteEntryState.AVAIL);
        this.renewCreateTimeUs();
        this.renewLastAccessTimeUs();
        this.renewLastValidTimeUs();
    }

    public ObRouteEntryState getState() {
        return this.state.get();
    }

    public void setDirtyState() {
        this.state.set(ObRouteEntryState.DIRTY);
    }

    public void setBuildingState() {
        this.state.set(ObRouteEntryState.BUILDING);
    }

    public void setDeletedState() {
        this.state.set(ObRouteEntryState.DELETED);
    }

    public boolean isBuildingState() {
        return ObRouteEntryState.BUILDING == this.state.get();
    }

    public boolean isAvailState() {
        return ObRouteEntryState.AVAIL == this.state.get();
    }

    public boolean isDirtyState() {
        return ObRouteEntryState.DIRTY == this.state.get();
    }

    public boolean isDeletedState() {
        return ObRouteEntryState.DELETED == this.state.get();
    }

    public boolean isUpdatingState() {
        return ObRouteEntryState.UPDATING == this.state.get();
    }

    public boolean setAvailToDirty() {
        return this.state.compareAndSet(ObRouteEntryState.AVAIL, ObRouteEntryState.DIRTY);
    }

    public boolean setDirtyToUpdating() {
        return this.state.compareAndSet(ObRouteEntryState.DIRTY, ObRouteEntryState.UPDATING);
    }

    private void renewCreateTimeUs() {
        this.createTimeUs = CommonUtils.getCurrentTimeUs();
    }

    public void renewLastValidTimeUs() {
        this.lastValidTimeUs = CommonUtils.getCurrentTimeUs();
    }

    public void renewLastAccessTimeUs() {
        this.lastAccessTimeUs = CommonUtils.getCurrentTimeUs();
    }

    public void renewLastUpdateTimeUs() {
        this.lastUpdateTimeUs = CommonUtils.getCurrentTimeUs();
    }

    public boolean isInDelayUpdateTime() {
        long intervalUs = CommonUtils.getCurrentTimeUs() - this.lastUpdateTimeUs;
        return this.lastUpdateTimeUs > 0L && intervalUs < 5000L;
    }

    public long getCreateTimeUs() {
        return this.createTimeUs;
    }

    public void setCreateTimeUs(long createTimeUs) {
        this.createTimeUs = createTimeUs;
    }

    public long getLastValidTimeUs() {
        return this.lastValidTimeUs;
    }

    public void setLastValidTimeUs(long lastValidTimeUs) {
        this.lastValidTimeUs = lastValidTimeUs;
    }

    public long getLastAccessTimeUs() {
        return this.lastAccessTimeUs;
    }

    public void setLastAccessTimeUs(long lastAccessTimeUs) {
        this.lastAccessTimeUs = lastAccessTimeUs;
    }

    public long getLastUpdateTimeUs() {
        return this.lastUpdateTimeUs;
    }

    public void setLastUpdateTimeUs(long lastUpdateTimeUs) {
        this.lastUpdateTimeUs = lastUpdateTimeUs;
    }

    public void setState(AtomicReference<ObRouteEntryState> state) {
        this.state = state;
    }
}

