/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.model;

import com.oceanbase.partition.calculator.model.ObServerRole;
import com.oceanbase.partition.calculator.model.ReplicaLocation;
import com.oceanbase.partition.calculator.model.TableLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class PartitionLocation
implements TableLocation {
    private static final int DEFAULT_REPLICA_COUNT = 3;
    private List<ReplicaLocation> replicas = new ArrayList<ReplicaLocation>(3);
    private long partId;
    private long schemaVersion;

    @Override
    public final boolean isValid() {
        return !this.replicas.isEmpty();
    }

    @Override
    public final ReplicaLocation getLeader() {
        Optional<ReplicaLocation> optional = this.getReplicas().stream().filter(r -> r.isLeader()).findFirst();
        return optional.isPresent() ? optional.get() : null;
    }

    public final ReplicaLocation removeLeader() {
        Iterator<ReplicaLocation> iter = this.getReplicas().iterator();
        while (iter.hasNext()) {
            ReplicaLocation replica = iter.next();
            if (!replica.isLeader()) continue;
            iter.remove();
            return replica;
        }
        return null;
    }

    public int replicaHash() {
        int hash = 1;
        for (ReplicaLocation replica : this.replicas) {
            hash += replica.hashCode();
        }
        return hash;
    }

    @Override
    public final boolean existLeader() {
        return this.getLeader() != null;
    }

    @Override
    public final long validCount() {
        return this.replicas.size();
    }

    public boolean isEmpty() {
        return this.replicas.isEmpty();
    }

    public void reset() {
        this.replicas.clear();
    }

    public boolean addReplica(ReplicaLocation replica) {
        if (replica == null || !replica.isValid()) {
            return false;
        }
        return this.replicas.add(replica);
    }

    public boolean setReplicas(List<ReplicaLocation> replicas) {
        if (CollectionUtils.isEmpty(replicas)) {
            return false;
        }
        return this.replicas.addAll(replicas.stream().filter(r -> r.isValid()).collect(Collectors.toList()));
    }

    public final PartitionLocation toFollower() {
        if (CollectionUtils.isEmpty(this.replicas)) {
            return null;
        }
        PartitionLocation partition = new PartitionLocation();
        for (ReplicaLocation replica : this.replicas) {
            partition.addReplica(new ReplicaLocation(ObServerRole.FOLLOWER, replica.getAddr(), replica.getReplicaType()));
        }
        return partition;
    }

    public boolean removeReplicaByAddr(ReplicaLocation replica) {
        if (replica == null) {
            return false;
        }
        Iterator<ReplicaLocation> it = this.replicas.iterator();
        while (it.hasNext()) {
            ReplicaLocation temp = it.next();
            if (!replica.getAddr().equals(temp.getAddr())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public boolean shuffle() {
        if (CollectionUtils.isEmpty(this.replicas)) {
            return false;
        }
        Collections.shuffle(this.replicas);
        return true;
    }

    public void priorityShuffle(int[] priorities) {
        int origCount = this.replicas.size();
        if (origCount < 2) {
            return;
        }
        Collections.sort(this.replicas);
        ArrayList<ReplicaLocation> tmpList = new ArrayList<ReplicaLocation>();
        for (int i = 0; i < origCount; ++i) {
            int currCount = this.replicas.size();
            int priIdx = i % priorities.length;
            int idx = priorities[priIdx] % currCount;
            ReplicaLocation tmpReplica = this.replicas.remove(idx);
            tmpList.add(tmpReplica);
        }
        this.replicas = tmpList;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PartitionLocation [ ");
        sb.append(this.replicas.stream().map(r -> r.getAddr().toString()).collect(Collectors.joining(", ")));
        return sb.append(" ]").toString();
    }

    @Override
    public String getLeaderAddress() {
        return this.getLeader().getAddr().getAddress();
    }

    @Override
    public List<ReplicaLocation> getReplicas() {
        return this.replicas;
    }

    public long getPartId() {
        return this.partId;
    }

    public void setPartId(long partId) {
        this.partId = partId;
    }

    @Override
    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(long schemaVersion) {
        this.schemaVersion = schemaVersion;
    }
}

