/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.model;

import com.oceanbase.partition.calculator.enums.ObServerMode;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class TableEntryKey {
    private String clusterName;
    private String tenantName;
    private String schemaName;
    private String tableName;
    private ObServerMode serverMode;

    public TableEntryKey() {
    }

    public TableEntryKey(String clusterName, String tenantName, String schemaName, String tableName, ObServerMode serverMode) {
        this.clusterName = clusterName;
        this.tenantName = tenantName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.serverMode = serverMode;
    }

    public static TableEntryKey getDummyEntryKey(String clusterName, String tenantName, ObServerMode serverMode) {
        return new TableEntryKey(clusterName, tenantName, "oceanbase", "__all_dummy", serverMode);
    }

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.getSchemaName()) && StringUtils.isNotBlank((CharSequence)this.getTenantName()) && StringUtils.isNotBlank((CharSequence)this.getTableName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TableEntryKey [ ");
        sb.append("cluster: ").append(this.clusterName).append(", tenant: ").append(this.tenantName);
        sb.append(", database: ").append(this.schemaName).append(", table: ").append(this.tableName);
        return sb.append(" ]").toString();
    }

    public int hashCode() {
        return Objects.hash(this.getClusterName(), this.getSchemaName(), this.getTenantName(), this.getTableName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableEntryKey other = (TableEntryKey)obj;
        return Objects.deepEquals(this.getClusterName(), other.getClusterName()) && Objects.deepEquals(this.getSchemaName(), other.getSchemaName()) && Objects.deepEquals(this.getTenantName(), other.getTenantName()) && Objects.deepEquals(this.getTableName(), other.getTableName());
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ObServerMode getServerMode() {
        return this.serverMode;
    }

    public void setServerMode(ObServerMode serverMode) {
        this.serverMode = serverMode;
    }
}

