/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.model;

import com.oceanbase.partition.calculator.model.ObServerRole;
import com.oceanbase.partition.calculator.model.PartitionLocation;
import com.oceanbase.partition.calculator.model.ReplicaLocation;
import com.oceanbase.partition.calculator.model.TableLocation;
import com.oceanbase.partition.calculator.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TenantLocation
implements TableLocation {
    private static final int DEFAULT_PARTITION_COUNT = 1;
    private long serverCount = 0L;
    private List<PartitionLocation> partitions = new ArrayList<PartitionLocation>(1);

    public static List<PartitionLocation> toPartitionList(List<ReplicaLocation> replicas) {
        if (null == replicas || replicas.isEmpty() || !replicas.get(0).isLeader()) {
            return null;
        }
        ArrayList<PartitionLocation> partitions = new ArrayList<PartitionLocation>();
        PartitionLocation partition = null;
        for (int i = 0; i < replicas.size(); ++i) {
            ReplicaLocation replica = new ReplicaLocation(replicas.get(i));
            if (replica.isLeader()) {
                replica.setRole(ObServerRole.FOLLOWER);
                partition = new PartitionLocation();
                partition.addReplica(replica);
                partitions.add(partition);
                continue;
            }
            partition.addReplica(replica);
        }
        return partitions;
    }

    @Override
    public final boolean isValid() {
        return this.serverCount > 0L && !this.partitions.isEmpty();
    }

    @Override
    public final boolean existLeader() {
        return false;
    }

    @Override
    public final ReplicaLocation getLeader() {
        return null;
    }

    public int partitionsHash() {
        int hashCode = 1;
        for (PartitionLocation part : this.partitions) {
            hashCode += part.replicaHash();
        }
        return hashCode;
    }

    public List<ReplicaLocation> getNextReplicas(int index) {
        PartitionLocation partition;
        List<ReplicaLocation> replicas = null;
        if (this.isValid() && null != (partition = this.getNextPartitionLocation(index))) {
            replicas = partition.getReplicas();
        }
        return replicas;
    }

    public PartitionLocation getNextPartitionLocation(int index) {
        if (this.isValid()) {
            return this.partitions.get(index %= this.partitions.size());
        }
        return null;
    }

    @Override
    public List<ReplicaLocation> getReplicas() {
        if (this.isValid()) {
            ArrayList<ReplicaLocation> allReplicas = new ArrayList<ReplicaLocation>((int)this.serverCount);
            ArrayList<ReplicaLocation> partitionReplicas = new ArrayList<ReplicaLocation>(3);
            int index = CommonUtils.randomInt(0, this.partitions.size());
            for (int i = 0; i < this.partitions.size(); ++i) {
                partitionReplicas.clear();
                partitionReplicas.addAll(this.getNextReplicas(index + i));
                Collections.shuffle(partitionReplicas);
                allReplicas.addAll(partitionReplicas);
            }
            return allReplicas;
        }
        return null;
    }

    public void setReplicas(List<ReplicaLocation> replicas) {
        List<PartitionLocation> partitions;
        this.reset();
        if (null != replicas && !replicas.isEmpty() && null != (partitions = TenantLocation.toPartitionList(replicas))) {
            for (PartitionLocation partition : partitions) {
                partition.shuffle();
                this.serverCount += partition.validCount();
                this.partitions.add(partition);
            }
            Collections.shuffle(this.partitions);
        }
    }

    @Override
    public final long validCount() {
        return this.serverCount;
    }

    public final long getPartitionCount() {
        return this.partitions.size();
    }

    public final long getReplicaCount(long partitionIdx) {
        if (partitionIdx >= (long)this.partitions.size() || partitionIdx < 0L) {
            return 0L;
        }
        return this.partitions.get((int)partitionIdx).validCount();
    }

    public void reset() {
        this.partitions.clear();
        this.serverCount = 0L;
    }

    public void addPartition(PartitionLocation partition) {
        PartitionLocation tmpPartition;
        if (partition.isValid() && null != (tmpPartition = partition.toFollower())) {
            tmpPartition.shuffle();
            this.serverCount += tmpPartition.validCount();
            this.partitions.add(tmpPartition);
        }
    }

    public void setPartition(PartitionLocation partition) {
        this.reset();
        this.addPartition(partition);
    }

    public void setPartitions(List<PartitionLocation> partitions) {
        this.reset();
        if (!partitions.isEmpty()) {
            for (int i = 0; i < partitions.size(); ++i) {
                PartitionLocation partition = partitions.get(i).toFollower();
                if (null == partition) continue;
                partition.shuffle();
                this.serverCount += partition.validCount();
                this.partitions.add(partition);
            }
            Collections.shuffle(this.partitions);
        }
    }

    public void setReplicasWithRsList(List<ReplicaLocation> replicas) {
        this.reset();
        if (null != replicas && !replicas.isEmpty()) {
            PartitionLocation partition = new PartitionLocation();
            for (int i = 0; i < replicas.size(); ++i) {
                ReplicaLocation replica = new ReplicaLocation(replicas.get(i));
                if (replica.isLeader()) {
                    replica.setRole(ObServerRole.FOLLOWER);
                }
                partition.addReplica(replica);
            }
            partition.shuffle();
            this.serverCount += partition.validCount();
            this.partitions.add(partition);
        }
    }

    @Override
    public long getSchemaVersion() {
        return 0L;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TenantLocation[ServerCount: ").append(this.serverCount);
        sb.append(", Partitions: ").append(this.partitions);
        return sb.toString();
    }

    public String toSimpleString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TenantLocation [ServerCount: ").append(this.serverCount);
        return sb.toString();
    }

    @Override
    public String getLeaderAddress() {
        return null;
    }
}

