/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.struct;

import com.oceanbase.partition.calculator.struct.ObCommonStruct;
import com.oceanbase.partition.calculator.utils.ObHashUtils;
import java.math.BigInteger;

public class ObIntervalDsValue
extends ObCommonStruct {
    private static final long serialVersionUID = 1214848925053839542L;
    private static final long HOURS_IN_DAY = 24L;
    private static final long MINUTES_IN_HOUR = 60L;
    private static final long SECONDS_IN_MINUTE = 60L;
    private long nsecond;
    private int fractionalSecond;

    public ObIntervalDsValue(Object intervalDsObj) {
        if (intervalDsObj == null) {
            return;
        }
        String intervalDs = intervalDsObj.toString().trim();
        int[] parts = new int[]{0, 0, 0, 0, 0};
        int index = 0;
        int length = intervalDs.length();
        StringBuilder sb = new StringBuilder(6);
        int seed = 1;
        for (int i = 0; i < length; ++i) {
            char ch = intervalDs.charAt(i);
            if (i == 0 && (ch == '-' || ch == '+')) {
                if (ch != '-') continue;
                seed = -1;
                continue;
            }
            if (ch != ' ' && ch != ':' && ch != '.' || i == length - 1) {
                sb.append(ch);
            }
            if (ch != ' ' && ch != ':' && ch != '.' && i != length - 1) continue;
            parts[index++] = Integer.parseInt(sb.toString());
            sb.setLength(0);
        }
        int days = parts[0];
        int hour = parts[1];
        int minute = parts[2];
        int second = parts[3];
        this.nsecond = (long)seed * ((((long)days * 24L + (long)hour) * 60L + (long)minute) * 60L + (long)second);
        this.fractionalSecond = seed * parts[4];
    }

    @Override
    public BigInteger murmurhash64A(BigInteger hashSeed) {
        BigInteger hashCode = hashSeed;
        hashCode = ObHashUtils.longHash(this.getNsecond(), hashCode);
        hashCode = ObHashUtils.intHash(this.getFractionalSecond(), hashCode);
        return hashCode;
    }

    public long getNsecond() {
        return this.nsecond;
    }

    public int getFractionalSecond() {
        return this.fractionalSecond;
    }
}

