/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.struct;

import com.oceanbase.partition.calculator.algo.hash.MurmurHash;
import com.oceanbase.partition.calculator.struct.ObCommonStruct;
import java.math.BigInteger;

public class ObString
extends ObCommonStruct {
    private static final long serialVersionUID = -6794741405557215824L;
    private String value;

    public ObString(Object stringObj) {
        if (stringObj != null) {
            this.value = stringObj.toString();
        }
    }

    @Override
    public BigInteger murmurhash64A(BigInteger hashSeed) {
        BigInteger hashValue = hashSeed;
        if (this.value == null || this.value.length() == 0) {
            return hashValue;
        }
        return MurmurHash.hash64(this.value.getBytes(), this.value.length(), hashValue);
    }

    public String getValue() {
        return this.value;
    }
}

