/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.calculator.struct;

import com.oceanbase.partition.calculator.struct.ObCommonStruct;
import com.oceanbase.partition.calculator.utils.ObHashUtils;
import java.math.BigInteger;
import java.sql.Timestamp;

public class ObTimestamp
extends ObCommonStruct {
    private static final long serialVersionUID = -2329357173970071116L;
    private long timeUs;
    private UnionTZCtx desc = new UnionTZCtx();

    public ObTimestamp(Object timestampObj) {
        this(timestampObj, false);
    }

    public ObTimestamp(Object timestampObj, boolean isUTC) {
        if (timestampObj instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)timestampObj;
            long sec = timestamp.toInstant().getEpochSecond();
            if (!isUTC) {
                sec -= (long)(timestamp.getTimezoneOffset() * 60);
            }
            int nano = timestamp.toInstant().getNano();
            this.timeUs = sec * 1000000L + (long)(nano / 1000);
            if (nano > 999999) {
                this.desc.setTailNsec(nano % 1000);
            }
        }
    }

    @Override
    public BigInteger murmurhash64A(BigInteger hashSeed) {
        BigInteger hashCode = hashSeed;
        hashCode = ObHashUtils.longHash(this.getTimeUs(), hashCode);
        hashCode = ObHashUtils.shortHash(this.getDesc().getStoreTzId() << 12 | this.getDesc().getTailNsec(), hashCode);
        return hashCode;
    }

    public long getTimeUs() {
        return this.timeUs;
    }

    public UnionTZCtx getDesc() {
        return this.desc;
    }

    public static class UnionTZCtx {
        private int desc;
        private int timeDesc;
        private int tailNsec;
        private int version;
        private int storeTzId;
        private int isNull;
        private int timeReserved;
        private int tzDesc;
        private int isNegOffset;
        private int offsetMin;
        private int offsetReserved;
        private int tzId;
        private int tranTypeId;

        public int getDesc() {
            return this.desc;
        }

        public void setDesc(int desc) {
            this.desc = desc;
        }

        public int getTimeDesc() {
            return this.timeDesc;
        }

        public void setTimeDesc(int timeDesc) {
            this.timeDesc = timeDesc;
        }

        public int getTailNsec() {
            return this.tailNsec;
        }

        public void setTailNsec(int tailNsec) {
            this.tailNsec = tailNsec;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public int getStoreTzId() {
            return this.storeTzId;
        }

        public void setStoreTzId(int storeTzId) {
            this.storeTzId = storeTzId;
        }

        public int getIsNull() {
            return this.isNull;
        }

        public void setIsNull(int isNull) {
            this.isNull = isNull;
        }

        public int getTimeReserved() {
            return this.timeReserved;
        }

        public void setTimeReserved(int timeReserved) {
            this.timeReserved = timeReserved;
        }

        public int getTzDesc() {
            return this.tzDesc;
        }

        public void setTzDesc(int tzDesc) {
            this.tzDesc = tzDesc;
        }

        public int getIsNegOffset() {
            return this.isNegOffset;
        }

        public void setIsNegOffset(int isNegOffset) {
            this.isNegOffset = isNegOffset;
        }

        public int getOffsetMin() {
            return this.offsetMin;
        }

        public void setOffsetMin(int offsetMin) {
            this.offsetMin = offsetMin;
        }

        public int getOffsetReserved() {
            return this.offsetReserved;
        }

        public void setOffsetReserved(int offsetReserved) {
            this.offsetReserved = offsetReserved;
        }

        public int getTzId() {
            return this.tzId;
        }

        public void setTzId(int tzId) {
            this.tzId = tzId;
        }

        public int getTranTypeId() {
            return this.tranTypeId;
        }

        public void setTranTypeId(int tranTypeId) {
            this.tranTypeId = tranTypeId;
        }
    }
}

