/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.metadata.desc;

import com.google.common.collect.Lists;
import com.oceanbase.partition.calculator.enums.ObObjType;
import com.oceanbase.partition.calculator.enums.ObPartFuncTypeOld;
import com.oceanbase.partition.calculator.enums.ObPartFuncTypeV4;
import com.oceanbase.partition.calculator.utils.CommonUtils;
import com.oceanbase.partition.metadata.desc.ObObject;
import com.oceanbase.partition.metadata.desc.ObPartDesc;
import com.oceanbase.partition.metadata.desc.ObPartItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObListPartDesc
extends ObPartDesc {
    private static final Logger log = LoggerFactory.getLogger(ObListPartDesc.class);
    private String tableName;
    private List<ObObjType> types;
    private Map<ObPartItem, Long> maps;
    private Map<Long, Map<ObPartItem, Long>> subMaps = new HashMap<Long, Map<ObPartItem, Long>>();

    public ObListPartDesc(boolean subsequentFromV4) {
        super(subsequentFromV4);
        if (subsequentFromV4) {
            super.setPartFuncType(ObPartFuncTypeV4.LIST);
        } else {
            super.setPartFuncType(ObPartFuncTypeOld.LIST);
        }
    }

    @Override
    public Long getRandomPartId() {
        if (MapUtils.isEmpty(this.maps)) {
            return null;
        }
        log.debug("Return a random partition id for the table: \"{}\"", (Object)this.tableName);
        int randomIndex = CommonUtils.randomInt(0, this.maps.size());
        return (Long)this.maps.values().toArray()[randomIndex];
    }

    @Override
    public Long getPartId(Object value) {
        return this.getPartId(Lists.newArrayList((Object[])new Object[]{value}));
    }

    @Override
    public Long getPartId(List<Object> values) {
        if (CollectionUtils.isEmpty(values) || MapUtils.isEmpty(this.getMaps())) {
            return null;
        }
        List<ObObject> obObjects = super.initParamByTypes(this.getTypes(), values);
        if (obObjects.size() != values.size()) {
            return null;
        }
        Long partId = this.getMaps().get(ObPartItem.getObPartItem(obObjects));
        return partId == null ? this.getMaps().get(ObPartDesc.DEFAULT_PART_ITEM) : partId;
    }

    @Override
    public Long getSubPartId(List<Object> values, Long firstPartId) {
        if (CollectionUtils.isEmpty(values) || MapUtils.isEmpty(this.getMaps())) {
            return null;
        }
        List<ObObject> obObjects = super.initParamByTypes(this.getTypes(), values);
        if (obObjects.size() != values.size()) {
            return null;
        }
        Long partId = 0L;
        if (this.isUseTemplate()) {
            partId = this.getMaps().get(ObPartItem.getObPartItem(obObjects));
        } else {
            Map<ObPartItem, Long> map = this.getSubMaps().get(firstPartId);
            partId = map.get(ObPartItem.getObPartItem(obObjects));
        }
        return partId == null ? this.getMaps().get(ObPartDesc.DEFAULT_PART_ITEM) : partId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObListPartDesc [ ").append(this.getTypes());
        sb.append("types: ").append(this.getTypes());
        sb.append(", maps: ").append(this.getMaps());
        sb.append(", partExpr: ").append(this.getPartExpr());
        sb.append(", partType: ").append(this.getPartFuncType());
        return sb.append(" ]").toString();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<ObObjType> getTypes() {
        return this.types;
    }

    public void setTypes(List<ObObjType> types) {
        this.types = types;
    }

    public Map<ObPartItem, Long> getMaps() {
        return this.maps;
    }

    public void setMaps(Map<ObPartItem, Long> maps) {
        this.maps = maps;
    }

    public Map<Long, Map<ObPartItem, Long>> getSubMaps() {
        return this.subMaps;
    }

    public void setSubMaps(Map<Long, Map<ObPartItem, Long>> subMaps) {
        this.subMaps = subMaps;
    }
}

