/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.metadata.desc;

import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.oceanbase.partition.calculator.constants.Constants;
import com.oceanbase.partition.calculator.enums.ObCollationType;
import com.oceanbase.partition.calculator.enums.ObObjType;
import com.oceanbase.partition.calculator.struct.ObDecimalInt;
import com.oceanbase.partition.calculator.struct.ObIntervalDsValue;
import com.oceanbase.partition.calculator.struct.ObIntervalYmValue;
import com.oceanbase.partition.calculator.struct.ObNumber;
import com.oceanbase.partition.calculator.struct.ObTimestamp;
import com.oceanbase.partition.calculator.utils.CommonUtils;
import com.oceanbase.partition.calculator.utils.ObHashUtils;
import com.oceanbase.partition.metadata.desc.ObPartColumn;
import com.oceanbase.utils.BigIntegerUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObObject
implements Comparable<ObObject> {
    private static final Logger log = LoggerFactory.getLogger(ObObject.class);
    private ObObjType type = ObObjType.UNKNOWN;
    private Comparable value;
    private int precision;
    private int scale;
    private ObCollationType collationType = ObCollationType.CS_TYPE_UTF8MB4_GENERAL_CI;

    public static ObObject getObObject(ObPartColumn partColumn, ObObjType type, String value) {
        ObObject obObject = new ObObject();
        obObject.setType(type);
        if (ObObjType.MAXVALUE.getName().equalsIgnoreCase(value)) {
            obObject.setType(ObObjType.MAXVALUE);
            return obObject;
        }
        if (value == null) {
            return obObject;
        }
        try {
            if (ObObjType.LONG == type) {
                if (value.contains(".")) {
                    obObject.setValue(Long.valueOf(Double.valueOf(value).longValue()));
                } else {
                    obObject.setValue(Long.valueOf(value));
                }
            } else if (ObObjType.DATE == type) {
                if (value.length() < 9) {
                    obObject.setValue((Comparable)((Object)value));
                } else {
                    Date date = CommonUtils.toDate(value);
                    if (date == null) {
                        obObject.setValue((Comparable)((Object)value));
                    } else {
                        obObject.setValue(date);
                    }
                }
            } else if (ObObjType.DATETIME == type) {
                if (value.length() < 9) {
                    obObject.setValue((Comparable)((Object)value));
                } else {
                    Timestamp ts = CommonUtils.toTimestamp(value);
                    if (ts == null) {
                        obObject.setValue((Comparable)((Object)value));
                    } else {
                        obObject.setValue(ts);
                    }
                }
            } else if (ObObjType.TIMESTAMP == type || ObObjType.TIMESTAMPLTZ == type) {
                Timestamp ts = CommonUtils.toTimestamp(value);
                if (ts == null) {
                    obObject.setValue((Comparable)((Object)value));
                } else {
                    obObject.setValue(ts);
                }
            } else if (ObObjType.NUMBER == type || ObObjType.DECIMALINT == type) {
                obObject.setScale(partColumn.getPartKeyScale());
                obObject.setPrecision(partColumn.getPartKeyPrecision());
                obObject.setValue((Comparable)((Object)value));
            } else {
                obObject.setValue((Comparable)((Object)value));
            }
        }
        catch (Exception e) {
            log.warn("Cast object failed, type: {}, value: {}. Error: {}", new Object[]{type, value, e.getMessage()});
            obObject = null;
        }
        return obObject;
    }

    public static ObObject convertToObObject(ObPartColumn partColumn, ObObjType type, Object value) {
        ObObject obj = new ObObject();
        obj.setType(type);
        if (value == null) {
            return obj;
        }
        if (value instanceof String) {
            return ObObject.getObObject(partColumn, type, (String)value);
        }
        switch (type) {
            case STRING: {
                obj.setValue((Comparable)((Object)String.valueOf(value)));
                break;
            }
            case LONG: {
                if (ObObjType.MAXVALUE.getName().equalsIgnoreCase(value.toString())) {
                    obj.setType(ObObjType.MAXVALUE);
                    return obj;
                }
                if (value instanceof Long) {
                    obj.setValue((Long)value);
                    break;
                }
                if (value instanceof Integer) {
                    obj.setValue(Long.valueOf(((Integer)value).intValue()));
                    break;
                }
                if (value instanceof Double) {
                    obj.setValue(Long.valueOf(((Double)value).longValue()));
                    break;
                }
                if (value instanceof Float) {
                    obj.setValue(Long.valueOf(((Float)value).longValue()));
                    break;
                }
                if (value == SQLEvalVisitor.EVAL_VALUE_NULL) {
                    obj.setValue(Long.valueOf(0L));
                    break;
                }
                obj = null;
                break;
            }
            case DATE: {
                if (value instanceof Date) {
                    obj.setValue((Date)value);
                    break;
                }
                if (value instanceof Timestamp) {
                    obj.setValue(new Date(((Timestamp)value).getTime()));
                    break;
                }
                if (value == SQLEvalVisitor.EVAL_VALUE_NULL) {
                    obj.setValue(new Date(0L));
                    break;
                }
                obj = null;
                break;
            }
            case DATETIME: {
                if (value instanceof Timestamp) {
                    obj.setValue((Timestamp)value);
                    break;
                }
                if (value instanceof Integer) {
                    obj.setValue((Integer)value);
                    break;
                }
                if (value == SQLEvalVisitor.EVAL_VALUE_NULL) {
                    obj.setValue(new Timestamp(0L));
                    break;
                }
                if (value instanceof Date) {
                    obj.setValue((Date)value);
                    break;
                }
                obj = null;
                break;
            }
            case DECIMALINT: 
            case NUMBER: {
                obj.setPrecision(partColumn.getPartKeyPrecision());
                obj.setScale(partColumn.getPartKeyScale());
                if (value instanceof Double) {
                    obj.setValue(BigDecimal.valueOf((Double)value));
                    break;
                }
                if (value instanceof Float) {
                    obj.setValue(BigDecimal.valueOf(((Float)value).floatValue()));
                    break;
                }
                if (value instanceof Long) {
                    obj.setValue((Long)value);
                    break;
                }
                if (value instanceof Integer) {
                    obj.setValue(Long.valueOf(((Integer)value).intValue()));
                    break;
                }
                if (value instanceof BigDecimal) {
                    obj.setValue((BigDecimal)value);
                    break;
                }
                if (value instanceof BigInteger) {
                    obj.setValue((BigInteger)value);
                    break;
                }
                if (value == SQLEvalVisitor.EVAL_VALUE_NULL) {
                    obj.setValue(Long.valueOf(0L));
                    break;
                }
                obj = null;
                break;
            }
            default: {
                obj = null;
            }
        }
        if (obj == null) {
            String logInfo = "Origin Value: null";
            if (value != null) {
                logInfo = "Origin Value: " + value + ", Origin Type: " + value.getClass();
            }
            log.warn("Convert object failed, type: {}, {}", (Object)type, (Object)logInfo);
        }
        return obj;
    }

    @Override
    public int compareTo(ObObject o) throws ClassCastException {
        if (ObObjType.MAXVALUE == o.getType()) {
            return ObObjType.MAXVALUE == this.getType() ? 0 : -1;
        }
        if (ObObjType.MAXVALUE == this.getType()) {
            return 1;
        }
        if (this.getType() == o.getType()) {
            switch (this.getType()) {
                case LONG: {
                    return ((Long)this.getValue()).compareTo((Long)o.getValue());
                }
                case DATE: {
                    return ((Date)this.getValue()).compareTo((Date)o.getValue());
                }
                case DATETIME: {
                    return ((Timestamp)this.getValue()).compareTo((Timestamp)o.getValue());
                }
                case TIMESTAMP: {
                    return ((Timestamp)this.getValue()).compareTo((Timestamp)o.getValue());
                }
                case NUMBER: {
                    return new ObNumber(this.value).compareTo(new ObNumber(o.getValue()));
                }
            }
            return this.getValue().compareTo(o.getValue());
        }
        throw new ClassCastException("Unmatched obobject type: " + (Object)((Object)this.type) + " <=> " + (Object)((Object)o.type));
    }

    public BigInteger hash(BigInteger hashCode, boolean isSubFromV3, boolean isNStringType, boolean isVarcharType, boolean oracleMode) {
        switch (this.type) {
            case LONG: {
                return ObHashUtils.longHash((Long)this.value, hashCode);
            }
            case DATE: {
                return ObHashUtils.dateHash((Date)this.value, hashCode);
            }
            case DATETIME: {
                String str = this.value.toString();
                try {
                    if (StringUtils.isBlank((CharSequence)str)) {
                        return Constants.BIGINTEGER_ZERO;
                    }
                    if (str.length() == 4) {
                        long unsignedInt8 = (Long.parseLong(str) - 1900L) % 256L;
                        return ObHashUtils.longHash(unsignedInt8, hashCode);
                    }
                    return ObHashUtils.datetimeHash(Timestamp.valueOf(str), hashCode);
                }
                catch (Exception e) {
                    LocalTime time = LocalTime.parse(str);
                    long seconds = time.getHour() * 3600 + time.getMinute() * 60 + time.getSecond();
                    long timeLongValue = BigIntegerUtils.add(BigIntegerUtils.multiply(BigInteger.valueOf(seconds), BigInteger.valueOf(1000000L)), BigInteger.valueOf(time.getNano() / 1000)).longValue();
                    return ObHashUtils.longHash(timeLongValue, hashCode);
                }
            }
            case NUMBER: {
                return new ObNumber(this.value, oracleMode).murmurhash64A(hashCode);
            }
            case DECIMALINT: {
                return new ObDecimalInt(this.value, this.precision, this.scale, oracleMode).murmurhash64A(hashCode);
            }
            case TIMESTAMP: {
                return new ObTimestamp(this.value).murmurhash64A(hashCode);
            }
            case TIMESTAMPTZ: {
                return new ObTimestamp(this.value).murmurhash64A(hashCode);
            }
            case TIMESTAMPLTZ: {
                return new ObTimestamp(this.value, true).murmurhash64A(hashCode);
            }
            case INTERVALYM: {
                return new ObIntervalYmValue(this.value).murmurhash64A(hashCode);
            }
            case INTERVALDS: {
                return new ObIntervalDsValue(this.value).murmurhash64A(hashCode);
            }
            case STRING: {
                String string = this.value == null ? null : String.valueOf(this.value);
                boolean calcEndSpace = oracleMode && isVarcharType;
                return ObHashUtils.varcharHash(string, this.collationType, hashCode, calcEndSpace, isSubFromV3);
            }
        }
        throw new ClassCastException("Unexpected obobject type: " + (Object)((Object)this.getType()));
    }

    public int hashCode() {
        String stringValue = String.valueOf(this.getValue());
        return Objects.hash(new Object[]{this.getType(), stringValue, this.getCollationType()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObObject other = (ObObject)obj;
        String thisValue = String.valueOf(this.getValue());
        String otherValue = String.valueOf(other.getValue());
        return Objects.deepEquals((Object)this.getType(), (Object)other.getType()) && Objects.deepEquals(thisValue, otherValue) && Objects.deepEquals((Object)this.getCollationType(), (Object)other.getCollationType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObObject [");
        sb.append(" hash: ").append(this.hashCode());
        sb.append(", value: ").append(this.getValue());
        sb.append(", type: ").append((Object)this.getType());
        sb.append(", collate: ").append((Object)this.getCollationType());
        return sb.append(" ]").toString();
    }

    public ObObjType getType() {
        return this.type;
    }

    public void setType(ObObjType type) {
        this.type = type;
    }

    public Comparable getValue() {
        return this.value;
    }

    public void setValue(Comparable value) {
        this.value = value;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public ObCollationType getCollationType() {
        return this.collationType;
    }

    public void setCollationType(ObCollationType collationType) {
        this.collationType = collationType;
    }
}

