/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.metadata.desc;

import com.oceanbase.partition.calculator.enums.ObObjType;
import com.oceanbase.partition.calculator.enums.ObPartFuncType;
import com.oceanbase.partition.calculator.enums.ObPartFuncTypeOld;
import com.oceanbase.partition.metadata.desc.ObObject;
import com.oceanbase.partition.metadata.desc.ObPartColumn;
import com.oceanbase.partition.metadata.desc.ObPartItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObPartDesc {
    private static final Logger log = LoggerFactory.getLogger(ObPartDesc.class);
    public static final String OBSERVER_V3 = "3.0";
    public static final ObPartItem DEFAULT_PART_ITEM = ObPartItem.getObPartItem(ObObject.convertToObObject(new ObPartColumn(), ObObjType.STRING, "default"));
    private final boolean subsequentFromV4;
    private String partExpr;
    private boolean useTemplate;
    private ObPartFuncType partFuncType;
    private Map<String, Long> partNameIdMap;
    private Map<Long, Long> partPositionIdMap;
    private Map<Long, Map<Long, Long>> subPartPositionIdMap;
    private Map<Long, List<String>> partIdSubNamesMap;
    private List<ObPartColumn> partColumns;

    public ObPartDesc(boolean subsequentV4) {
        this.subsequentFromV4 = subsequentV4;
        this.partExpr = "";
        this.partFuncType = ObPartFuncTypeOld.UNKNOWN;
    }

    protected List<ObObject> initParamByTypes(@NonNull List<ObObjType> types, @NonNull List<Object> values) {
        if (types == null) {
            throw new NullPointerException("types is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (values.size() != types.size()) {
            throw new IllegalArgumentException("part key values != part key types. table: " + this.getTableName());
        }
        ArrayList<ObObject> obObjects = new ArrayList<ObObject>(values.size());
        try {
            for (int i = 0; i < values.size(); ++i) {
                ObObject obObject = ObObject.convertToObObject(this.partColumns.get(i), types.get(i), values.get(i));
                if (obObject == null) continue;
                obObjects.add(obObject);
            }
        }
        catch (Exception e) {
            log.warn("Cast object failed, table: {}, types:{}, values:{}", new Object[]{this.getTableName(), types, values, e});
        }
        return obObjects;
    }

    protected ObObject toObObject(Object value, ObPartColumn column) {
        ObObject obObject = ObObject.convertToObObject(column, column.getObjType(), value);
        if (obObject != null && obObject.getType() == ObObjType.STRING) {
            obObject.setCollationType(column.getCollationType());
        }
        return obObject;
    }

    public abstract String getTableName();

    public abstract void setTableName(String var1);

    public abstract Long getRandomPartId();

    public abstract Long getPartId(Object var1);

    public abstract Long getPartId(List<Object> var1);

    public abstract Long getSubPartId(List<Object> var1, Long var2);

    public boolean isSubsequentFromV4() {
        return this.subsequentFromV4;
    }

    public String getPartExpr() {
        return this.partExpr;
    }

    public void setPartExpr(String partExpr) {
        this.partExpr = partExpr;
    }

    public boolean isUseTemplate() {
        return this.useTemplate;
    }

    public void setUseTemplate(boolean useTemplate) {
        this.useTemplate = useTemplate;
    }

    public ObPartFuncType getPartFuncType() {
        return this.partFuncType;
    }

    public void setPartFuncType(ObPartFuncType partFuncType) {
        this.partFuncType = partFuncType;
    }

    public Map<String, Long> getPartNameIdMap() {
        return this.partNameIdMap;
    }

    public void setPartNameIdMap(Map<String, Long> partNameIdMap) {
        this.partNameIdMap = partNameIdMap;
    }

    public Map<Long, Long> getPartPositionIdMap() {
        return this.partPositionIdMap;
    }

    public void setPartPositionIdMap(Map<Long, Long> partPositionIdMap) {
        this.partPositionIdMap = partPositionIdMap;
    }

    public Map<Long, Map<Long, Long>> getSubPartPositionIdMap() {
        return this.subPartPositionIdMap;
    }

    public void setSubPartPositionIdMap(Map<Long, Map<Long, Long>> subPartPositionIdMap) {
        this.subPartPositionIdMap = subPartPositionIdMap;
    }

    public Map<Long, List<String>> getPartIdSubNamesMap() {
        return this.partIdSubNamesMap;
    }

    public void setPartIdSubNamesMap(Map<Long, List<String>> partIdSubNamesMap) {
        this.partIdSubNamesMap = partIdSubNamesMap;
    }

    public List<ObPartColumn> getPartColumns() {
        return this.partColumns;
    }

    public void setPartColumns(List<ObPartColumn> partColumns) {
        this.partColumns = partColumns;
    }
}

