/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.metadata.desc;

import com.oceanbase.partition.calculator.enums.ObObjType;
import com.oceanbase.partition.metadata.desc.ObObject;
import com.oceanbase.partition.metadata.desc.ObPartColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ObPartItem
implements Comparable<ObPartItem> {
    private final List<ObObject> keys;
    private long firstPartId;

    private ObPartItem(int size) {
        this.keys = new ArrayList<ObObject>(size);
    }

    @Deprecated
    public static ObPartItem getObPartItem(List<ObPartColumn> partColumns, List<ObObjType> types, String parseString) throws IndexOutOfBoundsException {
        String[] highBoundArray;
        ObPartItem item = new ObPartItem(types.size());
        int index = 0;
        for (String highBound : highBoundArray = parseString.split(",")) {
            ObPartColumn partColumn = partColumns.get(index);
            ObObjType obObjType = types.get(index++);
            String plainString = ObPartItem.getPlainString(highBound);
            item.getKeys().add(ObObject.getObObject(partColumn, obObjType, plainString));
        }
        return item;
    }

    public static ObPartItem getObPartItem(List<ObPartColumn> partColumns, List<ObObjType> types, List<Object> highBoundArray) throws IndexOutOfBoundsException {
        ObPartItem item = new ObPartItem(types.size());
        int index = 0;
        for (Object highBound : highBoundArray) {
            ObPartColumn partColumn = partColumns.get(index);
            ObObjType obObjType = types.get(index++);
            item.getKeys().add(ObObject.convertToObObject(partColumn, obObjType, highBound));
        }
        return item;
    }

    public static ObPartItem getObPartItem(ObObject o) {
        ObPartItem item = new ObPartItem(1);
        item.getKeys().add(o);
        return item;
    }

    public static ObPartItem getObPartItem(List<ObObject> objectList) {
        ObPartItem item = new ObPartItem(1);
        item.getKeys().addAll(objectList);
        return item;
    }

    private static String getPlainString(String str) {
        int start = str.length() > 0 && str.charAt(0) == '\'' ? 1 : 0;
        int end = str.length() > 0 && str.charAt(str.length() - 1) == '\'' ? str.length() - 1 : str.length();
        return str.substring(start, end);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ObPartItem [ ");
        sb.append("hash: ").append(this.hashCode());
        sb.append(", keys: ").append(this.keys);
        return sb.append(" ]").toString();
    }

    @Override
    public int compareTo(ObPartItem other) {
        if (this.keys.size() != other.keys.size()) {
            throw new ClassCastException("Size not equal. Keys: " + this.keys + ", Others: " + other.keys);
        }
        int flag = 0;
        int size = this.keys.size();
        for (int i = 0; i < size; ++i) {
            ObObject obj2;
            ObObject obj1 = this.keys.get(i);
            flag = obj1.compareTo(obj2 = other.keys.get(i));
            if (flag == 0) continue;
            return flag;
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.getKeys());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObPartItem other = (ObPartItem)obj;
        return Objects.deepEquals(this.getKeys(), other.getKeys());
    }

    public List<ObObject> getKeys() {
        return this.keys;
    }

    public long getFirstPartId() {
        return this.firstPartId;
    }

    public void setFirstPartId(long firstPartId) {
        this.firstPartId = firstPartId;
    }
}

