/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.partition.metadata.desc;

import com.google.common.collect.Lists;
import com.oceanbase.partition.calculator.enums.ObObjType;
import com.oceanbase.partition.calculator.enums.ObPartFuncTypeOld;
import com.oceanbase.partition.calculator.enums.ObPartFuncTypeV4;
import com.oceanbase.partition.calculator.model.ObCmpKV;
import com.oceanbase.partition.calculator.utils.CommonUtils;
import com.oceanbase.partition.metadata.desc.ObObject;
import com.oceanbase.partition.metadata.desc.ObPartDesc;
import com.oceanbase.partition.metadata.desc.ObPartItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObRangePartDesc
extends ObPartDesc {
    private static final Logger log = LoggerFactory.getLogger(ObRangePartDesc.class);
    private String tableName;
    private List<ObObjType> types;
    private List<ObCmpKV<ObPartItem, Long>> bounds;
    private Map<Long, List<ObCmpKV<ObPartItem, Long>>> subBoundsMap = new HashMap<Long, List<ObCmpKV<ObPartItem, Long>>>();

    public ObRangePartDesc(boolean isSubsequentV4) {
        super(isSubsequentV4);
        if (isSubsequentV4) {
            super.setPartFuncType(ObPartFuncTypeV4.RANGE);
        } else {
            super.setPartFuncType(ObPartFuncTypeOld.RANGE);
        }
    }

    @Override
    public Long getRandomPartId() {
        if (null == this.bounds) {
            return null;
        }
        log.debug("Return a random partition id for the table: \"{}\"", (Object)this.tableName);
        int randomIndex = CommonUtils.randomInt(0, this.bounds.size());
        return (Long)this.bounds.get((int)randomIndex).value;
    }

    @Override
    public Long getPartId(Object value) {
        return this.getPartId(Lists.newArrayList((Object[])new Object[]{value}));
    }

    @Override
    public Long getPartId(List<Object> values) {
        if (CollectionUtils.isEmpty(values)) {
            return null;
        }
        List<ObObject> obObjects = super.initParamByTypes(this.getTypes(), values);
        if (obObjects.size() == values.size() && CollectionUtils.isNotEmpty(this.getBounds())) {
            ObPartItem item = ObPartItem.getObPartItem(obObjects);
            int idx = CommonUtils.upperBound(this.getBounds(), new ObCmpKV<ObPartItem, Long>(item, -1L));
            return this.getBounds().get(idx).getValue();
        }
        return null;
    }

    @Override
    public Long getSubPartId(List<Object> values, Long firstPartId) {
        if (CollectionUtils.isEmpty(values)) {
            return null;
        }
        List<ObObject> obObjects = super.initParamByTypes(this.getTypes(), values);
        if (obObjects.size() == values.size() && CollectionUtils.isNotEmpty(this.getBounds())) {
            ObPartItem item = ObPartItem.getObPartItem(obObjects);
            int idx = 0;
            List<ObCmpKV<ObPartItem, Long>> bounds = this.getSubBoundsMap().get(firstPartId);
            if (this.isUseTemplate()) {
                idx = CommonUtils.upperBound(this.getBounds(), new ObCmpKV<ObPartItem, Long>(item, -1L));
                return this.getBounds().get(idx).getValue();
            }
            idx = CommonUtils.upperBound(bounds, new ObCmpKV<ObPartItem, Long>(item, -1L));
            return bounds.get(idx).getValue();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObRangePartDesc [ ");
        sb.append("types: ").append(this.getTypes());
        sb.append(", bounds: ").append(this.getBounds());
        sb.append(", partExpr: ").append(this.getPartExpr());
        sb.append(", partType: ").append(this.getPartFuncType());
        return sb.append(" ]").toString();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<ObObjType> getTypes() {
        return this.types;
    }

    public void setTypes(List<ObObjType> types) {
        this.types = types;
    }

    public List<ObCmpKV<ObPartItem, Long>> getBounds() {
        return this.bounds;
    }

    public void setBounds(List<ObCmpKV<ObPartItem, Long>> bounds) {
        this.bounds = bounds;
    }

    public Map<Long, List<ObCmpKV<ObPartItem, Long>>> getSubBoundsMap() {
        return this.subBoundsMap;
    }

    public void setSubBoundsMap(Map<Long, List<ObCmpKV<ObPartItem, Long>>> subBoundsMap) {
        this.subBoundsMap = subBoundsMap;
    }
}

