/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.common.BaseOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.IndexOptions;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLIndexOptionsFactory
extends OBParserBaseVisitor<IndexOptions>
implements StatementFactory<IndexOptions> {
    private final OBParser.Opt_index_optionsContext optIndexOptionsContext;

    public MySQLIndexOptionsFactory(@NonNull OBParser.Opt_index_optionsContext optIndexOptionsContext) {
        if (optIndexOptionsContext == null) {
            throw new NullPointerException("optIndexOptionsContext is marked non-null but is null");
        }
        this.optIndexOptionsContext = optIndexOptionsContext;
    }

    @Override
    public IndexOptions generate() {
        return (IndexOptions)this.visit((ParseTree)this.optIndexOptionsContext);
    }

    @Override
    public IndexOptions visitOpt_index_options(OBParser.Opt_index_optionsContext ctx) {
        IndexOptions indexOptions = new IndexOptions(ctx);
        ctx.index_option().forEach(option -> {
            if (option.GLOBAL() != null) {
                indexOptions.setGlobal(true);
            } else if (option.LOCAL() != null) {
                indexOptions.setGlobal(false);
            } else if (option.BLOCK_SIZE() != null) {
                indexOptions.setBlockSize(this.getInteger((OBParser.Index_optionContext)((Object)option)));
            } else if (option.KEY_BLOCK_SIZE() != null) {
                indexOptions.setKeyBlockSize(this.getInteger((OBParser.Index_optionContext)((Object)option)));
            } else if (option.DATA_TABLE_ID() != null) {
                indexOptions.setDataTableId(this.getInteger((OBParser.Index_optionContext)((Object)option)));
            } else if (option.INDEX_TABLE_ID() != null) {
                indexOptions.setIndexTableId(this.getInteger((OBParser.Index_optionContext)((Object)option)));
            } else if (option.VIRTUAL_COLUMN_ID() != null) {
                indexOptions.setVirtualColumnId(this.getInteger((OBParser.Index_optionContext)((Object)option)));
            } else if (option.MAX_USED_PART_ID() != null) {
                indexOptions.setMaxUsedPartId(this.getInteger((OBParser.Index_optionContext)((Object)option)));
            } else if (option.COMMENT() != null) {
                indexOptions.setComment(option.STRING_VALUE().getText());
            } else if (option.STORING() != null) {
                indexOptions.setStoring(this.getReference((OBParser.Index_optionContext)((Object)option)));
            } else if (option.CTXCAT() != null) {
                indexOptions.setCtxcat(this.getReference((OBParser.Index_optionContext)((Object)option)));
            } else if (option.WITH() != null && option.PARSER() != null) {
                indexOptions.setWithParser(option.relation_name().getText());
            } else if (option.WITH() != null && option.ROWID() != null) {
                indexOptions.setWithRowId(true);
            } else if (option.WITH() != null && option.vec_index_params() != null) {
                HashMap<String, String> params = new HashMap<String, String>();
                option.vec_index_params().vec_index_param().forEach(i -> params.put(i.relation_name().getText(), i.vec_index_param_value().getText()));
                indexOptions.setVectorIndexParams(params);
            } else if (option.index_using_algorithm() != null) {
                indexOptions.merge((BaseOptions)this.visit((ParseTree)option.index_using_algorithm()));
            } else if (option.visibility_option() != null) {
                indexOptions.merge((BaseOptions)this.visit((ParseTree)option.visibility_option()));
            } else if (option.parallel_option() != null) {
                indexOptions.merge((BaseOptions)this.visit((ParseTree)option.parallel_option()));
            }
        });
        return indexOptions;
    }

    @Override
    public IndexOptions visitIndex_using_algorithm(OBParser.Index_using_algorithmContext ctx) {
        IndexOptions indexOptions = new IndexOptions(ctx);
        if (ctx.BTREE() != null) {
            indexOptions.setUsingBtree(true);
        } else if (ctx.HASH() != null) {
            indexOptions.setUsingHash(true);
        }
        return indexOptions;
    }

    @Override
    public IndexOptions visitVisibility_option(OBParser.Visibility_optionContext ctx) {
        IndexOptions indexOptions = new IndexOptions(ctx);
        indexOptions.setVisible(ctx.VISIBLE() != null);
        return indexOptions;
    }

    @Override
    public IndexOptions visitParallel_option(OBParser.Parallel_optionContext ctx) {
        IndexOptions indexOptions = new IndexOptions(ctx);
        if (ctx.NOPARALLEL() != null) {
            indexOptions.setNoParallel(true);
        } else {
            indexOptions.setParallel(Integer.valueOf(ctx.INTNUM().getText()));
        }
        return indexOptions;
    }

    private List<ColumnReference> getReference(OBParser.Index_optionContext option) {
        if (option.column_name_list() == null) {
            return null;
        }
        return option.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
    }

    private Integer getInteger(OBParser.Index_optionContext option) {
        if (option.INTNUM() == null) {
            return null;
        }
        return Integer.valueOf(option.INTNUM().getText());
    }
}

