/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLColumnRefFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSelectFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import com.oceanbase.tools.sqlparser.statement.insert.Insert;
import com.oceanbase.tools.sqlparser.statement.insert.InsertTable;
import com.oceanbase.tools.sqlparser.statement.insert.mysql.SetColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLInsertFactory
extends OBParserBaseVisitor<Insert>
implements StatementFactory<Insert> {
    private final OBParser.Insert_stmtContext insertStmtContext;

    public MySQLInsertFactory(@NonNull OBParser.Insert_stmtContext insertStmtContext) {
        if (insertStmtContext == null) {
            throw new NullPointerException("insertStmtContext is marked non-null but is null");
        }
        this.insertStmtContext = insertStmtContext;
    }

    @Override
    public Insert generate() {
        return (Insert)this.visit((ParseTree)this.insertStmtContext);
    }

    @Override
    public Insert visitInsert_stmt(OBParser.Insert_stmtContext ctx) {
        Insert insert = new Insert((ParserRuleContext)ctx, (Insert)this.visit((ParseTree)ctx.single_table_insert()));
        if (ctx.replace_with_opt_hint() != null) {
            insert.setReplace(true);
        }
        if (ctx.IGNORE() != null) {
            insert.setIgnore(true);
        }
        if (ctx.HIGH_PRIORITY() != null) {
            insert.setHighPriority(true);
        } else if (ctx.LOW_PRIORITY() != null) {
            insert.setLowPriority(true);
        }
        if (ctx.OVERWRITE() != null) {
            insert.setOverwrite(true);
        }
        if (ctx.update_asgn_list() != null) {
            insert.setOnDuplicateKeyUpdateColumns(this.getSetColumns(ctx.update_asgn_list()));
        }
        return insert;
    }

    @Override
    public Insert visitSingle_table_insert(OBParser.Single_table_insertContext ctx) {
        InsertTable insertTable = new InsertTable((ParserRuleContext)ctx, MySQLFromReferenceFactory.getRelationFactor(ctx.dml_table_name().relation_factor()));
        if (ctx.dml_table_name().use_partition() != null) {
            insertTable.setPartitionUsage(MySQLFromReferenceFactory.visitPartitionUsage(ctx.dml_table_name().use_partition()));
        }
        if (ctx.column_list() != null) {
            insertTable.setColumns(ctx.column_list().column_definition_ref().stream().map(c -> new MySQLColumnRefFactory((OBParser.Column_definition_refContext)((Object)c)).generate()).collect(Collectors.toList()));
        }
        if (ctx.values_clause() != null) {
            ArrayList<List<Expression>> values = new ArrayList<List<Expression>>();
            OBParser.Values_clauseContext vCtx = ctx.values_clause();
            if (vCtx.insert_vals_list() != null) {
                this.fullFillValues(vCtx.insert_vals_list(), values);
            } else {
                values.add(Collections.singletonList(new MySQLSelectFactory(vCtx.select_stmt()).generate()));
            }
            insertTable.setValues(values);
            insertTable.setAlias(this.getAlias(vCtx.table_subquery_alias()));
            insertTable.setAliasColumns(this.getAliasColumns(vCtx.table_subquery_alias()));
        }
        if (ctx.update_asgn_list() != null) {
            insertTable.setSetColumns(this.getSetColumns(ctx.update_asgn_list()));
            insertTable.setAlias(this.getAlias(ctx.table_subquery_alias()));
            insertTable.setAliasColumns(this.getAliasColumns(ctx.table_subquery_alias()));
        }
        return new Insert(ctx, Collections.singletonList(insertTable), null);
    }

    private List<String> getAliasColumns(OBParser.Table_subquery_aliasContext context) {
        if (context == null || context.alias_name_list() == null) {
            return null;
        }
        return context.alias_name_list().column_alias_name().stream().map(c -> c.column_name().getText()).collect(Collectors.toList());
    }

    private String getAlias(OBParser.Table_subquery_aliasContext context) {
        if (context == null) {
            return null;
        }
        return context.relation_name().getText();
    }

    private List<SetColumn> getSetColumns(OBParser.Update_asgn_listContext ctx) {
        return ctx.update_asgn_factor().stream().map(c -> {
            Expression val = c.expr_or_default().DEFAULT() != null ? new ConstExpression(c.expr_or_default().DEFAULT()) : new MySQLExpressionFactory(c.expr_or_default().expr()).generate();
            return new SetColumn((ParserRuleContext)c, new MySQLColumnRefFactory(c.column_definition_ref()).generate(), val);
        }).collect(Collectors.toList());
    }

    private void fullFillValues(OBParser.Insert_vals_listContext ctx, List<List<Expression>> values) {
        if (ctx.insert_vals_list() != null) {
            this.fullFillValues(ctx.insert_vals_list(), values);
        }
        ArrayList<Expression> vals = new ArrayList<Expression>();
        this.fullFillValues(ctx.insert_vals(), vals);
        values.add(vals);
    }

    private void fullFillValues(OBParser.Insert_valsContext ctx, List<Expression> values) {
        if (ctx.insert_vals() != null) {
            this.fullFillValues(ctx.insert_vals(), values);
        }
        if (ctx.empty() != null) {
            return;
        }
        if (ctx.expr_or_default().DEFAULT() != null) {
            values.add(new ConstExpression(ctx.expr_or_default().DEFAULT()));
        } else {
            values.add(new MySQLExpressionFactory(ctx.expr_or_default().expr()).generate());
        }
    }
}

