/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLForUpdateFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLLimitFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLOrderByFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLProjectionFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLSortKeyFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLWindowFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLWithTableFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.Window;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import com.oceanbase.tools.sqlparser.statement.select.ForUpdate;
import com.oceanbase.tools.sqlparser.statement.select.FromReference;
import com.oceanbase.tools.sqlparser.statement.select.GroupBy;
import com.oceanbase.tools.sqlparser.statement.select.NameReference;
import com.oceanbase.tools.sqlparser.statement.select.OrderBy;
import com.oceanbase.tools.sqlparser.statement.select.Projection;
import com.oceanbase.tools.sqlparser.statement.select.RelatedSelectBody;
import com.oceanbase.tools.sqlparser.statement.select.RelationType;
import com.oceanbase.tools.sqlparser.statement.select.SelectBody;
import com.oceanbase.tools.sqlparser.statement.select.SortKey;
import com.oceanbase.tools.sqlparser.statement.select.WithTable;
import com.oceanbase.tools.sqlparser.statement.select.mysql.Limit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class MySQLSelectBodyFactory
extends OBParserBaseVisitor<SelectBody>
implements StatementFactory<SelectBody> {
    private OBParser.Select_no_parensContext selectNoParensContext = null;
    private OBParser.Select_with_parensContext selectWithParensContext = null;

    public MySQLSelectBodyFactory(@NonNull OBParser.Select_no_parensContext selectNoParensContext) {
        if (selectNoParensContext == null) {
            throw new NullPointerException("selectNoParensContext is marked non-null but is null");
        }
        this.selectNoParensContext = selectNoParensContext;
    }

    public MySQLSelectBodyFactory(@NonNull OBParser.Select_with_parensContext selectWithParensContext) {
        if (selectWithParensContext == null) {
            throw new NullPointerException("selectWithParensContext is marked non-null but is null");
        }
        this.selectWithParensContext = selectWithParensContext;
    }

    @Override
    public SelectBody generate() {
        if (this.selectWithParensContext != null) {
            return (SelectBody)this.visit((ParseTree)this.selectWithParensContext);
        }
        return (SelectBody)this.visit((ParseTree)this.selectNoParensContext);
    }

    @Override
    public SelectBody visitSelect_with_parens(OBParser.Select_with_parensContext ctx) {
        SelectBody select = ctx.select_no_parens() != null ? new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_no_parens())) : new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_with_parens()));
        if (ctx.with_clause() != null) {
            OBParser.With_clauseContext w = ctx.with_clause();
            if (w.RECURSIVE() != null) {
                select.setRecursive(true);
            }
            select.getWith().addAll(w.with_list().common_table_expr().stream().map(c -> {
                MySQLWithTableFactory factory = new MySQLWithTableFactory((OBParser.Common_table_exprContext)((Object)c));
                return (WithTable)factory.generate();
            }).collect(Collectors.toList()));
        }
        return select;
    }

    @Override
    public SelectBody visitSelect_no_parens(OBParser.Select_no_parensContext ctx) {
        SelectBody select = ctx.select_clause() != null ? new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_clause())) : (ctx.select_clause_set() != null ? new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_clause_set())) : new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_clause_set_with_order_and_limit())));
        if (ctx.for_update_clause() != null) {
            MySQLForUpdateFactory factory = new MySQLForUpdateFactory(ctx.for_update_clause());
            select.getLastSelectBody().setForUpdate((ForUpdate)factory.generate());
        }
        if (ctx.opt_lock_in_share_mode() != null) {
            select.getLastSelectBody().setLockInShareMode(true);
        }
        return select;
    }

    @Override
    public SelectBody visitTable_values_clause(OBParser.Table_values_clauseContext ctx) {
        return new SelectBody((ParserRuleContext)ctx, ctx.values_row_list().row_value().stream().map(c -> this.getValueRows(c.insert_vals())).collect(Collectors.toList()));
    }

    @Override
    public SelectBody visitTable_values_clause_with_order_by_and_limit(OBParser.Table_values_clause_with_order_by_and_limitContext ctx) {
        SelectBody selectBody = new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.table_values_clause()));
        if (ctx.order_by() != null) {
            selectBody.setOrderBy(new MySQLOrderByFactory(ctx.order_by()).generate());
        }
        if (ctx.limit_clause() != null) {
            selectBody.setLimit(new MySQLLimitFactory(ctx.limit_clause()).generate());
        }
        return selectBody;
    }

    @Override
    public SelectBody visitSelect_with_parens_with_order_and_limit(OBParser.Select_with_parens_with_order_and_limitContext ctx) {
        OBParserBaseVisitor factory;
        SelectBody select = new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_with_parens()));
        if (ctx.order_by() != null) {
            factory = new MySQLOrderByFactory(ctx.order_by());
            select.getLastSelectBody().setOrderBy((OrderBy)factory.generate());
        }
        if (ctx.limit_clause() != null) {
            factory = new MySQLLimitFactory(ctx.limit_clause());
            select.getLastSelectBody().setLimit((Limit)factory.generate());
        }
        return select;
    }

    @Override
    public SelectBody visitSelect_clause_set_with_order_and_limit(OBParser.Select_clause_set_with_order_and_limitContext ctx) {
        OBParserBaseVisitor factory;
        SelectBody select = new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_clause_set()));
        if (ctx.order_by() != null) {
            factory = new MySQLOrderByFactory(ctx.order_by());
            select.getLastSelectBody().setOrderBy((OrderBy)factory.generate());
        }
        if (ctx.limit_clause() != null) {
            factory = new MySQLLimitFactory(ctx.limit_clause());
            select.getLastSelectBody().setLimit((Limit)factory.generate());
        }
        return select;
    }

    @Override
    public SelectBody visitSelect_clause_set(OBParser.Select_clause_setContext ctx) {
        SelectBody left = null;
        if (ctx.select_clause_set() != null) {
            OBParserBaseVisitor factory;
            left = new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_clause_set()));
            if (ctx.order_by() != null) {
                factory = new MySQLOrderByFactory(ctx.order_by());
                left.getLastSelectBody().setOrderBy((OrderBy)factory.generate());
            }
            if (ctx.limit_clause() != null) {
                factory = new MySQLLimitFactory(ctx.limit_clause());
                left.getLastSelectBody().setLimit((Limit)factory.generate());
            }
        } else if (ctx.select_clause_set_left() != null) {
            left = new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.select_clause_set_left()));
        }
        if (left == null) {
            throw new IllegalStateException("Missing left clause");
        }
        RelationType type = this.getRelationType(ctx.set_type());
        SelectBody right = (SelectBody)this.visit((ParseTree)ctx.select_clause_set_right());
        left.getLastSelectBody().setRelatedSelect(new RelatedSelectBody(right, type));
        return left;
    }

    private RelationType getRelationType(OBParser.Set_typeContext setType) {
        if (setType.set_type_other() != null) {
            return RelationType.valueOf(setType.set_type_other().getText().toUpperCase());
        }
        OBParser.Set_expression_optionContext op = setType.set_expression_option();
        if (op != null) {
            if (op.ALL() != null) {
                return RelationType.UNION_ALL;
            }
            if (op.DISTINCT() != null) {
                return RelationType.UNION_DISTINCT;
            }
            if (op.UNIQUE() != null) {
                return RelationType.UNION_UNIQUE;
            }
        }
        return RelationType.UNION;
    }

    @Override
    public SelectBody visitSimple_select_with_order_and_limit(OBParser.Simple_select_with_order_and_limitContext ctx) {
        SelectBody select = new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.simple_select()));
        if (ctx.order_by() != null) {
            select.setOrderBy(new MySQLOrderByFactory(ctx.order_by()).generate());
        }
        if (ctx.opt_approx() != null) {
            select.setApproximate(true);
        }
        if (ctx.limit_clause() != null) {
            select.setLimit(new MySQLLimitFactory(ctx.limit_clause()).generate());
        }
        return select;
    }

    @Override
    public SelectBody visitSimple_select(final OBParser.Simple_selectContext ctx) {
        return this.visitSelect(new SelectContext(){

            @Override
            public ParserRuleContext getTarget() {
                return ctx;
            }

            @Override
            public OBParser.Select_expr_listContext projectionList() {
                return ctx.select_expr_list();
            }

            @Override
            public List<FromReference> fromList() {
                return MySQLSelectBodyFactory.visitFromList(ctx.from_list());
            }

            @Override
            public OBParser.Groupby_clauseContext groupClause() {
                return ctx.groupby_clause();
            }

            @Override
            public TerminalNode whereNode() {
                return ctx.WHERE();
            }

            @Override
            public TerminalNode havingNode() {
                return ctx.HAVING();
            }

            @Override
            public List<OBParser.ExprContext> exprList() {
                return ctx.expr();
            }

            @Override
            public OBParser.Query_expression_option_listContext queryOptionList() {
                return ctx.query_expression_option_list();
            }

            @Override
            public OBParser.Named_windowsContext namedWindows() {
                return ctx.named_windows();
            }
        });
    }

    @Override
    public SelectBody visitNo_table_select_with_order_and_limit(OBParser.No_table_select_with_order_and_limitContext ctx) {
        OBParserBaseVisitor factory;
        SelectBody select = new SelectBody((ParserRuleContext)ctx, (SelectBody)this.visit((ParseTree)ctx.no_table_select()));
        if (ctx.order_by() != null) {
            factory = new MySQLOrderByFactory(ctx.order_by());
            select.setOrderBy((OrderBy)factory.generate());
        }
        if (ctx.limit_clause() != null) {
            factory = new MySQLLimitFactory(ctx.limit_clause());
            select.setLimit((Limit)factory.generate());
        }
        return select;
    }

    @Override
    public SelectBody visitNo_table_select(final OBParser.No_table_selectContext ctx) {
        return this.visitSelect(new SelectContext(){

            @Override
            public ParserRuleContext getTarget() {
                return ctx;
            }

            @Override
            public OBParser.Select_expr_listContext projectionList() {
                return ctx.select_expr_list();
            }

            @Override
            public List<FromReference> fromList() {
                if (ctx.DUAL() == null) {
                    return new ArrayList<FromReference>();
                }
                NameReference ref = new NameReference(ctx.DUAL(), null, ctx.DUAL().getText(), null);
                return Collections.singletonList(ref);
            }

            @Override
            public OBParser.Groupby_clauseContext groupClause() {
                return ctx.groupby_clause();
            }

            @Override
            public TerminalNode whereNode() {
                return ctx.WHERE();
            }

            @Override
            public TerminalNode havingNode() {
                return ctx.HAVING();
            }

            @Override
            public List<OBParser.ExprContext> exprList() {
                return ctx.expr();
            }

            @Override
            public OBParser.Query_expression_option_listContext queryOptionList() {
                return ctx.query_expression_option_list();
            }

            @Override
            public OBParser.Named_windowsContext namedWindows() {
                return ctx.named_windows();
            }
        });
    }

    private SelectBody visitSelect(SelectContext ctx) {
        MySQLExpressionFactory factory;
        List<Projection> selectItems = this.visitProjectionList(ctx.projectionList());
        SelectBody select = new SelectBody(ctx.getTarget(), selectItems, ctx.fromList());
        OBParser.ExprContext where = null;
        OBParser.ExprContext having = null;
        if (ctx.whereNode() != null && ctx.havingNode() != null) {
            where = ctx.exprList().get(0);
            if (where == null) {
                throw new IllegalStateException("Missing where clause");
            }
            having = ctx.exprList().get(1);
            if (having == null) {
                throw new IllegalStateException("Missing having clause");
            }
        } else if (ctx.whereNode() == null && ctx.havingNode() != null) {
            having = ctx.exprList().get(0);
        } else if (ctx.havingNode() == null && ctx.whereNode() != null) {
            where = ctx.exprList().get(0);
        }
        if (where != null) {
            factory = new MySQLExpressionFactory(where);
            select.setWhere((Expression)factory.generate());
        }
        if (having != null) {
            factory = new MySQLExpressionFactory(having);
            select.setHaving((Expression)factory.generate());
        }
        if (ctx.groupClause() != null) {
            if (ctx.groupClause().ROLLUP() != null) {
                select.setWithRollUp(true);
            }
            select.setGroupBy(this.visitGroupByClause(ctx.groupClause()));
        }
        if (ctx.queryOptionList() != null) {
            select.setQueryOptions(this.getQueryExpr(ctx.queryOptionList()));
        }
        if (ctx.namedWindows() != null) {
            select.setWindows(this.visitNamedWindows(ctx.namedWindows()));
        }
        return select;
    }

    private List<Projection> visitProjectionList(OBParser.Select_expr_listContext context) {
        return context.projection().stream().map(child -> {
            MySQLProjectionFactory factory = new MySQLProjectionFactory((OBParser.ProjectionContext)((Object)child));
            return (Projection)factory.generate();
        }).collect(Collectors.toList());
    }

    public static List<FromReference> visitFromList(OBParser.From_listContext context) {
        return MySQLSelectBodyFactory.visitFromList(context.table_references());
    }

    public static List<FromReference> visitFromList(OBParser.Table_referencesContext context) {
        List<FromReference> fromRefs = context.table_reference().stream().map(c -> {
            MySQLFromReferenceFactory factory = new MySQLFromReferenceFactory((OBParser.Table_referenceContext)((Object)c));
            return (FromReference)factory.generate();
        }).collect(Collectors.toList());
        fromRefs.addAll(context.table_references_paren().stream().flatMap(t -> {
            Stream<FromReference> s2 = t.table_reference().stream().map(r -> {
                MySQLFromReferenceFactory factory = new MySQLFromReferenceFactory((OBParser.Table_referenceContext)((Object)((Object)r)));
                return (FromReference)factory.generate();
            });
            if (t.table_references_paren() == null) {
                return s2;
            }
            Stream<FromReference> s1 = t.table_references_paren().table_reference().stream().map(r -> {
                MySQLFromReferenceFactory factory = new MySQLFromReferenceFactory((OBParser.Table_referenceContext)((Object)((Object)r)));
                return (FromReference)factory.generate();
            });
            return Stream.concat(s1, s2);
        }).collect(Collectors.toList()));
        return fromRefs;
    }

    private List<GroupBy> visitGroupByClause(OBParser.Groupby_clauseContext context) {
        return context.sort_list_for_group_by().sort_key_for_group_by().stream().map(c -> {
            MySQLSortKeyFactory factory = new MySQLSortKeyFactory((OBParser.Sort_key_for_group_byContext)((Object)c));
            return (SortKey)factory.generate();
        }).collect(Collectors.toList());
    }

    private List<Window> visitNamedWindows(OBParser.Named_windowsContext context) {
        return context.named_window().stream().map(c -> {
            MySQLWindowFactory factory = new MySQLWindowFactory((OBParser.Named_windowContext)((Object)c));
            return (Window)factory.generate();
        }).collect(Collectors.toList());
    }

    private String getQueryExpr(OBParser.Query_expression_option_listContext context) {
        return context.query_expression_option().stream().map(RuleContext::getText).collect(Collectors.joining(" "));
    }

    private List<Expression> getValueRows(OBParser.Insert_valsContext ctx) {
        Expression expr = null;
        if (ctx.expr_or_default() != null) {
            expr = ctx.expr_or_default().expr() == null ? new ConstExpression(ctx.expr_or_default().DEFAULT()) : new MySQLExpressionFactory(ctx.expr_or_default().expr()).generate();
        }
        if (ctx.empty() != null || expr == null) {
            return new ArrayList<Expression>();
        }
        List<Object> exprs = ctx.insert_vals() == null ? new ArrayList() : this.getValueRows(ctx.insert_vals());
        exprs.add(expr);
        return exprs;
    }

    static interface SelectContext {
        public ParserRuleContext getTarget();

        public OBParser.Select_expr_listContext projectionList();

        public List<FromReference> fromList();

        public OBParser.Groupby_clauseContext groupClause();

        public TerminalNode whereNode();

        public TerminalNode havingNode();

        public List<OBParser.ExprContext> exprList();

        public OBParser.Query_expression_option_listContext queryOptionList();

        public OBParser.Named_windowsContext namedWindows();
    }
}

