/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.mysql;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.mysql.MySQLExpressionFactory;
import com.oceanbase.tools.sqlparser.obmysql.OBParser;
import com.oceanbase.tools.sqlparser.obmysql.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.SortColumn;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.select.SortDirection;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySQLSortColumnFactory
extends OBParserBaseVisitor<SortColumn>
implements StatementFactory<SortColumn> {
    private final OBParser.Sort_column_keyContext sortColumnKeyContext;

    public MySQLSortColumnFactory(@NonNull OBParser.Sort_column_keyContext sortColumnKeyContext) {
        if (sortColumnKeyContext == null) {
            throw new NullPointerException("sortColumnKeyContext is marked non-null but is null");
        }
        this.sortColumnKeyContext = sortColumnKeyContext;
    }

    @Override
    public SortColumn generate() {
        return (SortColumn)this.visit((ParseTree)this.sortColumnKeyContext);
    }

    @Override
    public SortColumn visitSort_column_key(OBParser.Sort_column_keyContext ctx) {
        SortColumn sortColumn;
        if (ctx.expr() != null) {
            Expression e = new MySQLExpressionFactory(ctx.expr()).generate();
            sortColumn = new SortColumn((ParserRuleContext)ctx, e);
        } else {
            ColumnReference r = new ColumnReference(ctx.column_name(), null, null, ctx.column_name().getText());
            sortColumn = new SortColumn((ParserRuleContext)ctx, r);
            if (ctx.LeftParen() != null && ctx.RightParen() != null) {
                sortColumn.setLength(Integer.valueOf(ctx.INTNUM(0).getText()));
            }
        }
        SortDirection direction = null;
        if (ctx.ASC() != null) {
            direction = SortDirection.ASC;
        } else if (ctx.DESC() != null) {
            direction = SortDirection.DESC;
        }
        sortColumn.setDirection(direction);
        if (ctx.ID() != null) {
            sortColumn.setId(Integer.valueOf(ctx.INTNUM(ctx.INTNUM().size() - 1).getText()));
        }
        return sortColumn;
    }
}

