/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleColumnGroupElementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleFromReferenceFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleIndexOptionsFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OraclePartitionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleSortColumnFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleTableElementFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.common.ColumnGroupElement;
import com.oceanbase.tools.sqlparser.statement.createindex.CreateIndex;
import com.oceanbase.tools.sqlparser.statement.createtable.IndexOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.SortColumn;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleCreateIndexFactory
extends OBParserBaseVisitor<CreateIndex>
implements StatementFactory<CreateIndex> {
    private final OBParser.Create_index_stmtContext createIndexStmtContext;

    public OracleCreateIndexFactory(@NonNull OBParser.Create_index_stmtContext createIndexStmtContext) {
        if (createIndexStmtContext == null) {
            throw new NullPointerException("createIndexStmtContext is marked non-null but is null");
        }
        this.createIndexStmtContext = createIndexStmtContext;
    }

    @Override
    public CreateIndex generate() {
        return (CreateIndex)this.visit((ParseTree)this.createIndexStmtContext);
    }

    @Override
    public CreateIndex visitCreate_index_stmt(OBParser.Create_index_stmtContext ctx) {
        List<SortColumn> columns = ctx.sort_column_list().sort_column_key().stream().map(c -> new OracleSortColumnFactory((OBParser.Sort_column_keyContext)((Object)c)).generate()).collect(Collectors.toList());
        CreateIndex index = new CreateIndex(ctx, OracleFromReferenceFactory.getRelationFactor(ctx.normal_relation_factor()), OracleFromReferenceFactory.getRelationFactor(ctx.relation_factor()), columns);
        if (ctx.INDEXTYPE() != null && ctx.MDSYS() != null && ctx.SPATIAL_INDEX() != null) {
            index.setMdSysDotSpatialIndex(true);
        }
        if (ctx.opt_index_options() != null) {
            IndexOptions options = new OracleIndexOptionsFactory(ctx.opt_index_options()).generate();
            OBParser.Index_using_algorithmContext context = ctx.index_using_algorithm();
            if (context != null) {
                if (options.getUsingHash() == null) {
                    options.setUsingHash(OracleTableElementFactory.isUsingHash(context));
                }
                if (options.getUsingBtree() == null) {
                    options.setUsingBtree(OracleTableElementFactory.isUsingBTree(context));
                }
            }
            index.setIndexOptions(options);
        }
        if (ctx.UNIQUE() != null) {
            index.setUnique(true);
        }
        if (ctx.partition_option() != null) {
            index.setPartition(new OraclePartitionFactory(ctx.partition_option()).generate());
        } else if (ctx.auto_partition_option() != null) {
            index.setPartition(new OraclePartitionFactory(ctx.auto_partition_option()).generate());
        }
        if (ctx.with_column_group() != null) {
            List<ColumnGroupElement> columnGroupElements = ctx.with_column_group().column_group_list().column_group_element().stream().map(c -> new OracleColumnGroupElementFactory((OBParser.Column_group_elementContext)((Object)c)).generate()).collect(Collectors.toList());
            index.setColumnGroupElements(columnGroupElements);
        }
        return index;
    }
}

