/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OraclePartitionElementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleSubPartitionOptionFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.HashPartition;
import com.oceanbase.tools.sqlparser.statement.createtable.HashPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.ListPartition;
import com.oceanbase.tools.sqlparser.statement.createtable.ListPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.Partition;
import com.oceanbase.tools.sqlparser.statement.createtable.RangePartition;
import com.oceanbase.tools.sqlparser.statement.createtable.RangePartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionOption;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class OraclePartitionFactory
extends OBParserBaseVisitor<Partition>
implements StatementFactory<Partition> {
    private final ParserRuleContext parserRuleContext;

    public OraclePartitionFactory(@NonNull OBParser.Partition_optionContext partitionOptionContext) {
        if (partitionOptionContext == null) {
            throw new NullPointerException("partitionOptionContext is marked non-null but is null");
        }
        this.parserRuleContext = partitionOptionContext;
    }

    public OraclePartitionFactory(@NonNull OBParser.Auto_partition_optionContext autoPartitionOptionContext) {
        if (autoPartitionOptionContext == null) {
            throw new NullPointerException("autoPartitionOptionContext is marked non-null but is null");
        }
        this.parserRuleContext = autoPartitionOptionContext;
    }

    public OraclePartitionFactory(@NonNull OBParser.Hash_partition_optionContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        this.parserRuleContext = ctx;
    }

    public OraclePartitionFactory(@NonNull OBParser.Range_partition_optionContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        this.parserRuleContext = ctx;
    }

    public OraclePartitionFactory(@NonNull OBParser.List_partition_optionContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        this.parserRuleContext = ctx;
    }

    @Override
    public Partition generate() {
        return (Partition)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public Partition visitHash_partition_option(OBParser.Hash_partition_optionContext ctx) {
        List<Expression> targets = ctx.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        List<HashPartitionElement> partitionElts = null;
        if (ctx.hash_partition_list() != null) {
            partitionElts = ctx.hash_partition_list().hash_partition_element().stream().map(c -> (HashPartitionElement)new OraclePartitionElementFactory((OBParser.Hash_partition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        }
        Integer num = null;
        if (ctx.INTNUM() != null) {
            num = Integer.valueOf(ctx.INTNUM().getText());
        }
        HashPartition hashPartition = new HashPartition((ParserRuleContext)ctx, targets, partitionElts, this.getSubPartitionOption(ctx.subpartition_option()), num);
        if (ctx.hash_partition_attributes_option_list() != null) {
            hashPartition.setPartitionOptions(OraclePartitionElementFactory.getPartitionOptions(ctx.hash_partition_attributes_option_list()));
        }
        return hashPartition;
    }

    @Override
    public Partition visitRange_partition_option(OBParser.Range_partition_optionContext ctx) {
        List<Expression> targets = ctx.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        List<RangePartitionElement> partitionElts = ctx.opt_range_partition_list().range_partition_list().range_partition_element().stream().map(c -> (RangePartitionElement)new OraclePartitionElementFactory((OBParser.Range_partition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        RangePartition partition = new RangePartition(ctx, targets, partitionElts, this.getSubPartitionOption(ctx.subpartition_option()), null, false);
        if (ctx.interval_option() != null) {
            partition.setInterval(new OracleExpressionFactory(ctx.interval_option().bit_expr()).generate());
        }
        return partition;
    }

    @Override
    public Partition visitAuto_partition_option(OBParser.Auto_partition_optionContext ctx) {
        List targets = null;
        OBParser.Auto_range_typeContext context = ctx.auto_partition_type().auto_range_type();
        if (context.column_name_list() != null) {
            targets = context.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        }
        RangePartition rangePartition = new RangePartition(ctx, targets, null, null, null, false);
        rangePartition.setAuto(true);
        rangePartition.setPartitionSize(new ConstExpression(ctx.partition_size()));
        return rangePartition;
    }

    @Override
    public Partition visitList_partition_option(OBParser.List_partition_optionContext ctx) {
        List<Expression> targets = ctx.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
        List<ListPartitionElement> partitionElts = ctx.opt_list_partition_list().list_partition_list().list_partition_element().stream().map(c -> (ListPartitionElement)new OraclePartitionElementFactory((OBParser.List_partition_elementContext)((Object)c)).generate()).collect(Collectors.toList());
        return new ListPartition(ctx, targets, partitionElts, this.getSubPartitionOption(ctx.subpartition_option()), null, false);
    }

    private List<ColumnReference> getColumnReferences(OBParser.Vertical_column_nameContext cxt) {
        ArrayList<ColumnReference> list = new ArrayList<ColumnReference>();
        if (cxt.column_name() != null) {
            list.add(new ColumnReference(cxt.column_name(), null, null, cxt.column_name().getText()));
            return list;
        }
        return cxt.column_name_list().column_name().stream().map(c -> new ColumnReference((ParserRuleContext)c, null, null, c.getText())).collect(Collectors.toList());
    }

    private SubPartitionOption getSubPartitionOption(OBParser.Subpartition_optionContext context) {
        return context == null ? null : new OracleSubPartitionOptionFactory(context).generate();
    }
}

