/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import com.oceanbase.tools.sqlparser.statement.select.PartitionType;
import com.oceanbase.tools.sqlparser.statement.select.PartitionUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class OraclePartitionUsageFactory
extends OBParserBaseVisitor<PartitionUsage>
implements StatementFactory<PartitionUsage> {
    private final OBParser.Use_partitionContext usePartitionContext;

    public OraclePartitionUsageFactory(@NonNull OBParser.Use_partitionContext usePartitionContext) {
        if (usePartitionContext == null) {
            throw new NullPointerException("usePartitionContext is marked non-null but is null");
        }
        this.usePartitionContext = usePartitionContext;
    }

    @Override
    public PartitionUsage generate() {
        return (PartitionUsage)this.visit((ParseTree)this.usePartitionContext);
    }

    @Override
    public PartitionUsage visitUse_partition(OBParser.Use_partitionContext ctx) {
        PartitionType type = PartitionType.PARTITION;
        if (ctx.SUBPARTITION() != null) {
            type = PartitionType.SUB_PARTITION;
        }
        if (ctx.name_list() != null) {
            ArrayList<String> nameList = new ArrayList<String>();
            this.visitNameList(ctx.name_list(), nameList);
            return new PartitionUsage((ParserRuleContext)ctx, type, nameList);
        }
        HashMap<String, Expression> externalTablePartition = new HashMap<String, Expression>();
        this.visitExternalTablePartitions(ctx.external_table_partitions(), externalTablePartition);
        return new PartitionUsage((ParserRuleContext)ctx, type, externalTablePartition);
    }

    private void visitExternalTablePartitions(OBParser.External_table_partitionsContext ctx, Map<String, Expression> externalTablePartition) {
        if (ctx == null) {
            return;
        }
        externalTablePartition.put(ctx.external_table_partition().relation_name().getText(), new ConstExpression(ctx.external_table_partition().expr_const()));
        this.visitExternalTablePartitions(ctx.external_table_partitions(), externalTablePartition);
    }

    private void visitNameList(OBParser.Name_listContext ctx, List<String> nameList) {
        if (ctx.relation_name() != null && ctx.name_list() == null) {
            nameList.add(ctx.relation_name().getText());
            return;
        }
        this.visitNameList(ctx.name_list(), nameList);
        nameList.add(ctx.relation_name().getText());
    }
}

