/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.adapter.oracle;

import com.oceanbase.tools.sqlparser.adapter.StatementFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleColumnRefFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleDataTypeFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleExpressionFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleIndexOptionsFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleSequenceOptionsFactory;
import com.oceanbase.tools.sqlparser.adapter.oracle.OracleSortColumnFactory;
import com.oceanbase.tools.sqlparser.oboracle.OBParser;
import com.oceanbase.tools.sqlparser.oboracle.OBParserBaseVisitor;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.DataType;
import com.oceanbase.tools.sqlparser.statement.createtable.ColumnAttributes;
import com.oceanbase.tools.sqlparser.statement.createtable.ColumnDefinition;
import com.oceanbase.tools.sqlparser.statement.createtable.ConstraintState;
import com.oceanbase.tools.sqlparser.statement.createtable.ForeignReference;
import com.oceanbase.tools.sqlparser.statement.createtable.GenerateOption;
import com.oceanbase.tools.sqlparser.statement.createtable.InLineCheckConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.InLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.InLineForeignConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.IndexOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineCheckConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineForeignConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineIndex;
import com.oceanbase.tools.sqlparser.statement.createtable.SortColumn;
import com.oceanbase.tools.sqlparser.statement.createtable.TableElement;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.expression.ConstExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ExpressionParam;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionCall;
import com.oceanbase.tools.sqlparser.statement.expression.FunctionParam;
import com.oceanbase.tools.sqlparser.statement.sequence.SequenceOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;

public class OracleTableElementFactory
extends OBParserBaseVisitor<TableElement>
implements StatementFactory<TableElement> {
    private final ParserRuleContext parserRuleContext;

    public OracleTableElementFactory(@NonNull OBParser.Table_elementContext tableElementContext) {
        if (tableElementContext == null) {
            throw new NullPointerException("tableElementContext is marked non-null but is null");
        }
        this.parserRuleContext = tableElementContext;
    }

    public OracleTableElementFactory(@NonNull OBParser.Column_definition_opt_datatypeContext parserRuleContext) {
        if (parserRuleContext == null) {
            throw new NullPointerException("parserRuleContext is marked non-null but is null");
        }
        this.parserRuleContext = parserRuleContext;
    }

    public OracleTableElementFactory(@NonNull OBParser.Column_definitionContext parserRuleContext) {
        if (parserRuleContext == null) {
            throw new NullPointerException("parserRuleContext is marked non-null but is null");
        }
        this.parserRuleContext = parserRuleContext;
    }

    public OracleTableElementFactory(@NonNull OBParser.Out_of_line_constraintContext parserRuleContext) {
        if (parserRuleContext == null) {
            throw new NullPointerException("parserRuleContext is marked non-null but is null");
        }
        this.parserRuleContext = parserRuleContext;
    }

    public OracleTableElementFactory(@NonNull OBParser.Out_of_line_primary_indexContext parserRuleContext) {
        if (parserRuleContext == null) {
            throw new NullPointerException("parserRuleContext is marked non-null but is null");
        }
        this.parserRuleContext = parserRuleContext;
    }

    @Override
    public TableElement generate() {
        return (TableElement)this.visit((ParseTree)this.parserRuleContext);
    }

    @Override
    public TableElement visitOut_of_line_constraint(OBParser.Out_of_line_constraintContext ctx) {
        OutOfLineConstraint constraint;
        String constraintName;
        String string = constraintName = ctx.constraint_and_name() == null ? null : ctx.constraint_and_name().constraint_name().getText();
        if (ctx.out_of_line_unique_index() != null) {
            constraint = new OutOfLineConstraint((ParserRuleContext)ctx, (OutOfLineConstraint)this.visit((ParseTree)ctx.out_of_line_unique_index()));
        } else if (ctx.out_of_line_primary_index() != null) {
            constraint = new OutOfLineConstraint((ParserRuleContext)ctx, (OutOfLineConstraint)this.visit((ParseTree)ctx.out_of_line_primary_index()));
        } else if (ctx.FOREIGN() != null) {
            List<SortColumn> columns = ctx.column_name_list().column_name().stream().map(c -> new SortColumn((ParserRuleContext)c, new ColumnReference((ParserRuleContext)c, null, null, c.getText()))).collect(Collectors.toList());
            ConstraintState state = this.visitConstraintState(ctx.constraint_state());
            constraint = new OutOfLineForeignConstraint(ctx, state, columns, this.visitForeignReference(ctx.references_clause()));
        } else {
            Expression checkExpr = new OracleExpressionFactory(ctx.expr()).generate();
            ConstraintState state = this.visitConstraintState(ctx.constraint_state());
            constraint = new OutOfLineCheckConstraint((ParserRuleContext)ctx, state, checkExpr);
        }
        constraint.setConstraintName(constraintName);
        return constraint;
    }

    @Override
    public TableElement visitOut_of_line_primary_index(OBParser.Out_of_line_primary_indexContext ctx) {
        List<SortColumn> columns = ctx.column_name_list().column_name().stream().map(c -> new SortColumn((ParserRuleContext)c, new ColumnReference((ParserRuleContext)c, null, null, c.getText()))).collect(Collectors.toList());
        ConstraintState state = this.visitConstraintState(ctx.out_of_line_index_state());
        OutOfLineConstraint outOfLineConstraint = new OutOfLineConstraint(ctx, state, columns);
        outOfLineConstraint.setPrimaryKey(true);
        return outOfLineConstraint;
    }

    @Override
    public TableElement visitOut_of_line_unique_index(OBParser.Out_of_line_unique_indexContext ctx) {
        List<SortColumn> columns = ctx.sort_column_list().sort_column_key().stream().map(c -> new OracleSortColumnFactory((OBParser.Sort_column_keyContext)((Object)c)).generate()).collect(Collectors.toList());
        ConstraintState state = this.visitConstraintState(ctx.out_of_line_index_state());
        OutOfLineConstraint outOfLineConstraint = new OutOfLineConstraint(ctx, state, columns);
        outOfLineConstraint.setUniqueKey(true);
        return outOfLineConstraint;
    }

    @Override
    public TableElement visitOut_of_line_index(OBParser.Out_of_line_indexContext ctx) {
        String name = ctx.index_name() == null ? null : ctx.index_name().getText();
        List<SortColumn> columns = ctx.sort_column_list().sort_column_key().stream().map(c -> new OracleSortColumnFactory((OBParser.Sort_column_keyContext)((Object)c)).generate()).collect(Collectors.toList());
        OutOfLineIndex index = new OutOfLineIndex(ctx, name, columns);
        index.setIndexOptions(this.getIndexOptions(ctx.index_using_algorithm(), ctx.opt_index_options()));
        return index;
    }

    @Override
    public TableElement visitColumn_definition(final OBParser.Column_definitionContext ctx) {
        return this.getColumnDefinition(new ColumnContextProvider(){

            @Override
            public ParserRuleContext getSelf() {
                return ctx;
            }

            @Override
            public OBParser.Data_typeContext getDataTypeCtx() {
                return ctx.data_type();
            }

            @Override
            public OBParser.Column_definition_refContext getColumnDefinitionRefCtx() {
                return ctx.column_definition_ref();
            }

            @Override
            public OBParser.Visibility_optionContext getVisibilityOptionCtx() {
                return ctx.visibility_option();
            }

            @Override
            public TerminalNode getAsNode() {
                return ctx.AS();
            }

            @Override
            public OBParser.Opt_identity_attributeContext getOptIdentityAttributeCtx() {
                return ctx.opt_identity_attribute();
            }

            @Override
            public OBParser.Sequence_option_listContext getSequenceOptionListCtx() {
                return ctx.sequence_option_list();
            }

            @Override
            public OBParser.Bit_exprContext getBitExprCtx() {
                return ctx.bit_expr();
            }

            @Override
            public OBParser.Opt_generated_option_listContext getOptGeneratedOptionListCtx() {
                return ctx.opt_generated_option_list();
            }

            @Override
            public TerminalNode getVirtualNode() {
                return ctx.VIRTUAL();
            }

            @Override
            public OBParser.Opt_column_attribute_listContext getOptColumnAttributeListCtx() {
                return ctx.opt_column_attribute_list();
            }

            @Override
            public OBParser.Opt_generated_column_attribute_listContext getOptGeneratedColumnAttributeListCtx() {
                return ctx.opt_generated_column_attribute_list();
            }
        });
    }

    @Override
    public TableElement visitColumn_definition_opt_datatype(final OBParser.Column_definition_opt_datatypeContext ctx) {
        return this.getColumnDefinition(new ColumnContextProvider(){

            @Override
            public ParserRuleContext getSelf() {
                return ctx;
            }

            @Override
            public OBParser.Data_typeContext getDataTypeCtx() {
                return ctx.data_type();
            }

            @Override
            public OBParser.Column_definition_refContext getColumnDefinitionRefCtx() {
                return ctx.column_definition_ref();
            }

            @Override
            public OBParser.Visibility_optionContext getVisibilityOptionCtx() {
                return ctx.visibility_option();
            }

            @Override
            public TerminalNode getAsNode() {
                return ctx.AS();
            }

            @Override
            public OBParser.Opt_identity_attributeContext getOptIdentityAttributeCtx() {
                return ctx.opt_identity_attribute();
            }

            @Override
            public OBParser.Sequence_option_listContext getSequenceOptionListCtx() {
                return ctx.sequence_option_list();
            }

            @Override
            public OBParser.Bit_exprContext getBitExprCtx() {
                return ctx.bit_expr();
            }

            @Override
            public OBParser.Opt_generated_option_listContext getOptGeneratedOptionListCtx() {
                return ctx.opt_generated_option_list();
            }

            @Override
            public TerminalNode getVirtualNode() {
                return ctx.VIRTUAL();
            }

            @Override
            public OBParser.Opt_column_attribute_listContext getOptColumnAttributeListCtx() {
                return ctx.opt_column_attribute_list();
            }

            @Override
            public OBParser.Opt_generated_column_attribute_listContext getOptGeneratedColumnAttributeListCtx() {
                return ctx.opt_generated_column_attribute_list();
            }
        });
    }

    private ColumnDefinition getColumnDefinition(ColumnContextProvider ctx) {
        ColumnAttributes attributes;
        DataType dataType = null;
        if (ctx.getDataTypeCtx() != null) {
            dataType = new OracleDataTypeFactory(ctx.getDataTypeCtx()).generate();
        }
        OracleColumnRefFactory factory = new OracleColumnRefFactory(ctx.getColumnDefinitionRefCtx());
        ColumnDefinition definition = new ColumnDefinition(ctx.getSelf(), (ColumnReference)factory.generate(), dataType);
        if (ctx.getVisibilityOptionCtx() != null) {
            definition.setVisible(ctx.getVisibilityOptionCtx().INVISIBLE() == null);
        }
        if (ctx.getAsNode() != null) {
            GenerateOption generateOption;
            if (ctx.getOptIdentityAttributeCtx() != null) {
                SequenceOptions options = null;
                if (ctx.getSequenceOptionListCtx() != null) {
                    options = new OracleSequenceOptionsFactory(ctx.getSequenceOptionListCtx()).generate();
                }
                generateOption = new GenerateOption(ctx.getSelf(), options);
            } else {
                OracleExpressionFactory exprFactory = new OracleExpressionFactory(ctx.getBitExprCtx());
                generateOption = new GenerateOption(ctx.getSelf(), (Expression)exprFactory.generate());
            }
            if (ctx.getOptGeneratedOptionListCtx() != null) {
                OBParser.Opt_generated_option_listContext c = ctx.getOptGeneratedOptionListCtx();
                CharStream input = c.getStart().getInputStream();
                String str = input.getText(Interval.of((int)c.getStart().getStartIndex(), (int)c.getStop().getStopIndex()));
                generateOption.setGenerateOption(StringUtils.isEmpty((CharSequence)str) ? null : str);
            }
            if (ctx.getVirtualNode() != null) {
                generateOption.setType(GenerateOption.Type.VIRTUAL);
            }
            definition.setGenerateOption(generateOption);
        }
        if (ctx.getOptColumnAttributeListCtx() != null) {
            attributes = this.visitColumnAttributeList(ctx.getOptColumnAttributeListCtx());
            definition.setColumnAttributes(attributes);
        } else if (ctx.getOptGeneratedColumnAttributeListCtx() != null) {
            attributes = this.visitGeneratedColumnAttributeList(ctx.getOptGeneratedColumnAttributeListCtx());
            definition.setColumnAttributes(attributes);
        }
        return definition;
    }

    private ConstraintState visitConstraintState(OBParser.Out_of_line_index_stateContext context) {
        if (context == null) {
            return null;
        }
        ConstraintState state = new ConstraintState(context);
        if (context.USING() != null && context.INDEX() != null) {
            state.setUsingIndexFlag(true);
        }
        if (context.opt_index_options() != null) {
            state.setIndexOptions(new OracleIndexOptionsFactory(context.opt_index_options()).generate());
        }
        return state;
    }

    private ColumnAttributes visitColumnAttributeList(OBParser.Opt_column_attribute_listContext context) {
        ColumnAttributes attributes = new ColumnAttributes(context);
        if (context.opt_column_attribute_list() != null) {
            attributes.merge(this.visitColumnAttributeList(context.opt_column_attribute_list()));
        }
        attributes.merge(this.visitColumnAttribute(context.column_attribute()));
        return attributes;
    }

    private ColumnAttributes visitColumnAttribute(OBParser.Column_attributeContext ctx) {
        ColumnAttributes attributes = new ColumnAttributes(ctx);
        if (ctx.DEFAULT() != null) {
            attributes.setDefaultValue(new OracleExpressionFactory(ctx.bit_expr()).generate());
        } else if (ctx.ORIG_DEFAULT() != null) {
            attributes.setOrigDefault(this.visitNowOrSignedLiteral(ctx.now_or_signed_literal()));
        } else if (ctx.ID() != null) {
            attributes.setId(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.SRID() != null) {
            attributes.setSrid(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.SKIP_INDEX() != null) {
            ArrayList<String> skipIndexTypes = new ArrayList<String>();
            if (ctx.opt_skip_index_type_list() != null) {
                this.getSkipIndexTypes(ctx.opt_skip_index_type_list(), skipIndexTypes);
            }
            if (ctx.skip_index_type() != null) {
                skipIndexTypes.add(ctx.skip_index_type().getText());
            }
            attributes.setSkipIndexTypes(skipIndexTypes);
        } else {
            String name = null;
            if (ctx.constraint_and_name() != null) {
                name = ctx.constraint_and_name().constraint_name().getText();
            }
            ConstraintState state = this.visitConstraintState(ctx.constraint_state());
            if (ctx.CHECK() == null && ctx.references_clause() == null) {
                InLineConstraint attribute = new InLineConstraint(ctx, name, state);
                if (ctx.NULLX() != null) {
                    attribute.setNullable(ctx.NOT() == null);
                }
                if (ctx.PRIMARY() != null) {
                    attribute.setPrimaryKey(true);
                }
                if (ctx.UNIQUE() != null) {
                    attribute.setUniqueKey(true);
                }
                attributes.setConstraints(Collections.singletonList(attribute));
            } else if (ctx.CHECK() != null) {
                Expression expr = new OracleExpressionFactory(ctx.expr()).generate();
                attributes.setConstraints(Collections.singletonList(new InLineCheckConstraint(ctx, name, state, expr)));
            } else {
                attributes.setConstraints(Collections.singletonList(new InLineForeignConstraint(ctx, name, state, this.visitForeignReference(ctx.references_clause()))));
            }
        }
        return attributes;
    }

    public static Boolean isUsingBTree(OBParser.Index_using_algorithmContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.BTREE() == null) {
            return null;
        }
        return true;
    }

    public static Boolean isUsingHash(OBParser.Index_using_algorithmContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.HASH() == null) {
            return null;
        }
        return true;
    }

    private ColumnAttributes visitGeneratedColumnAttributeList(OBParser.Opt_generated_column_attribute_listContext cxt) {
        ColumnAttributes attributes = new ColumnAttributes(cxt);
        if (cxt.opt_generated_column_attribute_list() != null) {
            attributes.merge(this.visitGeneratedColumnAttributeList(cxt.opt_generated_column_attribute_list()));
        }
        attributes.merge(this.visitGeneratedColumnAttribute(cxt.generated_column_attribute()));
        return attributes;
    }

    private ColumnAttributes visitGeneratedColumnAttribute(OBParser.Generated_column_attributeContext ctx) {
        ColumnAttributes attributes = new ColumnAttributes(ctx);
        if (ctx.ID() != null) {
            attributes.setId(Integer.valueOf(ctx.INTNUM().getText()));
        } else if (ctx.COMMENT() != null) {
            attributes.setComment(ctx.STRING_VALUE().getText());
        } else if (ctx.SRID() != null) {
            attributes.setSrid(Integer.valueOf(ctx.INTNUM().getText()));
        } else {
            String name = null;
            if (ctx.constraint_and_name() != null) {
                name = ctx.constraint_and_name().constraint_name().getText();
            }
            ConstraintState state = this.visitConstraintState(ctx.constraint_state());
            InLineConstraint attribute = new InLineConstraint(ctx, name, state);
            if (ctx.CHECK() != null) {
                attribute = new InLineCheckConstraint(ctx, name, state, new OracleExpressionFactory(ctx.expr()).generate());
            }
            if (ctx.NULLX() != null) {
                attribute.setNullable(ctx.NOT() == null);
            }
            if (ctx.PRIMARY() != null) {
                attribute.setPrimaryKey(true);
            }
            if (ctx.UNIQUE() != null) {
                attribute.setUniqueKey(true);
            }
            if (ctx.PRIMARY() == null && ctx.UNIQUE() == null && ctx.KEY() != null) {
                attribute.setPrimaryKey(true);
            }
            attributes.setConstraints(Collections.singletonList(attribute));
        }
        return attributes;
    }

    private Expression visitNowOrSignedLiteral(OBParser.Now_or_signed_literalContext context) {
        if (context.cur_timestamp_func_params() != null) {
            return this.visitCurTimestampFuncParams(context.cur_timestamp_func_params());
        }
        return this.visitSignedLiteralParams(context.signed_literal_params());
    }

    private ConstraintState visitConstraintState(OBParser.Constraint_stateContext context) {
        if (context == null || context.getChildCount() == 0) {
            return null;
        }
        ConstraintState constraintState = new ConstraintState(context);
        if (context.RELY() != null || context.NORELY() != null) {
            constraintState.setRely(context.RELY() != null);
        }
        if (context.USING() != null && context.INDEX() != null) {
            constraintState.setUsingIndexFlag(true);
            IndexOptions indexOptions = this.getIndexOptions(null, context.opt_index_options());
            constraintState.setIndexOptions(indexOptions);
        }
        if (context.enable_option() != null) {
            constraintState.setEnable(context.enable_option().ENABLE() != null);
        }
        if (context.VALIDATE() != null || context.NOVALIDATE() != null) {
            constraintState.setValidate(context.VALIDATE() != null);
        }
        return constraintState;
    }

    private IndexOptions getIndexOptions(OBParser.Index_using_algorithmContext c1, OBParser.Opt_index_optionsContext c2) {
        if (c1 == null && c2 == null) {
            return null;
        }
        if (c2 != null && c1 == null) {
            return new OracleIndexOptionsFactory(c2).generate();
        }
        if (c2 == null) {
            IndexOptions indexOptions = new IndexOptions(c1);
            indexOptions.setUsingBtree(OracleTableElementFactory.isUsingBTree(c1));
            indexOptions.setUsingHash(OracleTableElementFactory.isUsingHash(c1));
            return indexOptions;
        }
        IndexOptions first = this.getIndexOptions(c1, null);
        IndexOptions second = this.getIndexOptions(null, c2);
        if (second.getUsingHash() == null) {
            second.setUsingHash(first.getUsingHash());
        }
        if (second.getUsingBtree() == null) {
            second.setUsingBtree(first.getUsingBtree());
        }
        return second;
    }

    private ForeignReference visitForeignReference(OBParser.References_clauseContext context) {
        OBParser.Normal_relation_factorContext c = context.normal_relation_factor();
        String schema = null;
        if (c.database_factor() != null) {
            schema = c.database_factor().getText();
        }
        String tableName = c.relation_name().getText();
        List<ColumnReference> columns = new ArrayList<ColumnReference>();
        if (context.column_name_list() != null) {
            columns = context.column_name_list().column_name().stream().map(c1 -> new ColumnReference((ParserRuleContext)c1, null, null, c1.getText())).collect(Collectors.toList());
        }
        ForeignReference foreignReference = new ForeignReference(context, schema, tableName, columns);
        if (c.USER_VARIABLE() != null) {
            foreignReference.setUserVariable(c.USER_VARIABLE().getText());
        }
        if (context.reference_option() != null) {
            OBParser.Reference_optionContext i = context.reference_option();
            if (i.reference_action().CASCADE() != null) {
                foreignReference.setDeleteOption(ForeignReference.OnOption.CASCADE);
            } else if (i.reference_action().SET() != null) {
                foreignReference.setDeleteOption(ForeignReference.OnOption.SET_NULL);
            }
        }
        return foreignReference;
    }

    private Expression visitCurTimestampFuncParams(OBParser.Cur_timestamp_func_paramsContext context) {
        if (context.cur_timestamp_func_params() != null) {
            return this.visitCurTimestampFuncParams(context.cur_timestamp_func_params());
        }
        OBParser.Cur_timestamp_funcContext ctx = context.cur_timestamp_func();
        String funcName = ctx.getChild(0).getText();
        ArrayList<FunctionParam> params = new ArrayList<FunctionParam>();
        if (ctx.INTNUM() != null) {
            params.add(new ExpressionParam(new ConstExpression(ctx.INTNUM())));
        }
        return new FunctionCall(context, funcName, params);
    }

    private Expression visitSignedLiteralParams(OBParser.Signed_literal_paramsContext context) {
        if (context.signed_literal_params() != null) {
            return this.visitSignedLiteralParams(context.signed_literal_params());
        }
        return OracleExpressionFactory.getExpression(context.signed_literal());
    }

    private void getSkipIndexTypes(OBParser.Opt_skip_index_type_listContext ctx, List<String> types) {
        if (ctx.opt_skip_index_type_list() != null) {
            this.getSkipIndexTypes(ctx.opt_skip_index_type_list(), types);
        }
        if (ctx.skip_index_type() != null) {
            types.add(ctx.skip_index_type().getText());
        }
    }

    private static interface ColumnContextProvider {
        public ParserRuleContext getSelf();

        public OBParser.Data_typeContext getDataTypeCtx();

        public OBParser.Column_definition_refContext getColumnDefinitionRefCtx();

        public OBParser.Visibility_optionContext getVisibilityOptionCtx();

        public TerminalNode getAsNode();

        public OBParser.Opt_identity_attributeContext getOptIdentityAttributeCtx();

        public OBParser.Sequence_option_listContext getSequenceOptionListCtx();

        public OBParser.Bit_exprContext getBitExprCtx();

        public OBParser.Opt_generated_option_listContext getOptGeneratedOptionListCtx();

        public TerminalNode getVirtualNode();

        public OBParser.Opt_column_attribute_listContext getOptColumnAttributeListCtx();

        public OBParser.Opt_generated_column_attribute_listContext getOptGeneratedColumnAttributeListCtx();
    }
}

