/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.alter.table;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.alter.table.AlterTableAction;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class AlterTable
extends BaseStatement {
    private RelationFactor relation;
    private String userVariable;
    private boolean external;
    private final List<AlterTableAction> alterTableActions;

    public AlterTable(@NonNull ParserRuleContext context, RelationFactor relation, List<AlterTableAction> alterTableActions) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.relation = relation;
        this.alterTableActions = alterTableActions;
    }

    public AlterTable(@NonNull RelationFactor relation, List<AlterTableAction> alterTableActions) {
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        this.relation = relation;
        this.alterTableActions = alterTableActions;
    }

    public String getSchema() {
        if (this.relation == null) {
            return null;
        }
        return this.relation.getSchema();
    }

    public String getTableName() {
        if (this.relation == null) {
            return null;
        }
        return this.relation.getRelation();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.external) {
            builder.append("ALTER EXTERNAL TABLE");
        } else {
            builder.append("ALTER TABLE");
        }
        if (this.getSchema() != null) {
            builder.append(" ").append(this.getSchema()).append(".").append(this.getTableName());
        } else if (this.getTableName() != null) {
            builder.append(" ").append(this.getTableName());
        }
        if (this.userVariable != null) {
            builder.append(this.userVariable);
        }
        if (CollectionUtils.isNotEmpty(this.alterTableActions)) {
            builder.append(" ").append(this.alterTableActions.stream().map(AlterTableAction::toString).collect(Collectors.joining(",")));
        }
        return builder.toString();
    }

    public RelationFactor getRelation() {
        return this.relation;
    }

    public String getUserVariable() {
        return this.userVariable;
    }

    public boolean isExternal() {
        return this.external;
    }

    public List<AlterTableAction> getAlterTableActions() {
        return this.alterTableActions;
    }

    public void setRelation(RelationFactor relation) {
        this.relation = relation;
    }

    public void setUserVariable(String userVariable) {
        this.userVariable = userVariable;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlterTable)) {
            return false;
        }
        AlterTable other = (AlterTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelationFactor this$relation = this.getRelation();
        RelationFactor other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !((Object)this$relation).equals(other$relation)) {
            return false;
        }
        String this$userVariable = this.getUserVariable();
        String other$userVariable = other.getUserVariable();
        if (this$userVariable == null ? other$userVariable != null : !this$userVariable.equals(other$userVariable)) {
            return false;
        }
        if (this.isExternal() != other.isExternal()) {
            return false;
        }
        List<AlterTableAction> this$alterTableActions = this.getAlterTableActions();
        List<AlterTableAction> other$alterTableActions = other.getAlterTableActions();
        return !(this$alterTableActions == null ? other$alterTableActions != null : !((Object)this$alterTableActions).equals(other$alterTableActions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlterTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationFactor $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : ((Object)$relation).hashCode());
        String $userVariable = this.getUserVariable();
        result = result * 59 + ($userVariable == null ? 43 : $userVariable.hashCode());
        result = result * 59 + (this.isExternal() ? 79 : 97);
        List<AlterTableAction> $alterTableActions = this.getAlterTableActions();
        result = result * 59 + ($alterTableActions == null ? 43 : ((Object)$alterTableActions).hashCode());
        return result;
    }
}

