/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class BaseOptions
extends BaseStatement {
    protected BaseOptions() {
    }

    protected BaseOptions(TerminalNode terminalNode) {
        super(terminalNode);
    }

    protected BaseOptions(ParserRuleContext ruleNode) {
        super(ruleNode);
    }

    public <T extends BaseOptions> void merge(@NonNull T other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        if (!Objects.equals(other.getClass(), this.getClass())) {
            throw new IllegalArgumentException("Merged object's type is illegal");
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.getClass(), BaseStatement.class);
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                Object otherVal = pd.getReadMethod().invoke(other, new Object[0]);
                if (otherVal == null) continue;
                this.doMerge(pd, otherVal);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void doMerge(PropertyDescriptor pd, Object otherVal) throws InvocationTargetException, IllegalAccessException {
        if (pd.getWriteMethod() == null) {
            return;
        }
        pd.getWriteMethod().invoke((Object)this, otherVal);
    }
}

