/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;

public class ColumnGroupElement
extends BaseStatement {
    private boolean allColumns;
    private boolean eachColumn;
    private String groupName;
    private List<String> columnNames;

    public ColumnGroupElement(boolean allColumns, boolean eachColumn) {
        this.allColumns = allColumns;
        this.eachColumn = eachColumn;
    }

    public ColumnGroupElement(String groupName, List<String> columnNames) {
        this.groupName = groupName;
        this.columnNames = columnNames;
    }

    public ColumnGroupElement(ParserRuleContext ruleNode, boolean allColumns, boolean eachColumn) {
        super(ruleNode);
        this.allColumns = allColumns;
        this.eachColumn = eachColumn;
    }

    public ColumnGroupElement(ParserRuleContext ruleNode, String groupName, List<String> columnNames) {
        super(ruleNode);
        this.groupName = groupName;
        this.columnNames = columnNames;
    }

    public String toString() {
        if (this.isAllColumns()) {
            return "ALL COLUMNS";
        }
        if (this.isEachColumn()) {
            return "EACH COLUMN";
        }
        return String.format("%s(%s)", this.groupName, String.join((CharSequence)",", this.columnNames));
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public boolean isEachColumn() {
        return this.eachColumn;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnGroupElement)) {
            return false;
        }
        ColumnGroupElement other = (ColumnGroupElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllColumns() != other.isAllColumns()) {
            return false;
        }
        if (this.isEachColumn() != other.isEachColumn()) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        List<String> this$columnNames = this.getColumnNames();
        List<String> other$columnNames = other.getColumnNames();
        return !(this$columnNames == null ? other$columnNames != null : !((Object)this$columnNames).equals(other$columnNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnGroupElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllColumns() ? 79 : 97);
        result = result * 59 + (this.isEachColumn() ? 79 : 97);
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        List<String> $columnNames = this.getColumnNames();
        result = result * 59 + ($columnNames == null ? 43 : ((Object)$columnNames).hashCode());
        return result;
    }
}

