/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.DataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class NumberType
extends BaseStatement
implements DataType {
    private final String typeName;
    private final BigDecimal precision;
    private final BigDecimal scale;
    private boolean starPresicion;
    private Boolean signed;
    private boolean zeroFill;

    public NumberType(@NonNull ParserRuleContext context, @NonNull String typeName, BigDecimal precision, BigDecimal scale) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (typeName == null) {
            throw new NullPointerException("typeName is marked non-null but is null");
        }
        this.typeName = typeName;
        this.precision = precision;
        this.scale = scale;
    }

    public NumberType(@NonNull String typeName, BigDecimal precision, BigDecimal scale) {
        if (typeName == null) {
            throw new NullPointerException("typeName is marked non-null but is null");
        }
        this.typeName = typeName;
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    public List<String> getArguments() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.precision != null) {
            args.add(this.precision.toString());
        } else if (this.starPresicion) {
            args.add("*");
        }
        if (this.scale != null) {
            args.add(this.scale.toString());
        }
        return args;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.typeName.toUpperCase());
        if (!this.getArguments().isEmpty()) {
            builder.append("(").append(String.join((CharSequence)",", this.getArguments())).append(")");
        }
        if (this.signed != null) {
            builder.append(" ").append(this.signed != false ? "SIGNED" : "UNSIGNED");
        }
        if (this.zeroFill) {
            builder.append(" ").append("ZEROFILL");
        }
        return builder.toString();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public BigDecimal getPrecision() {
        return this.precision;
    }

    public BigDecimal getScale() {
        return this.scale;
    }

    public boolean isStarPresicion() {
        return this.starPresicion;
    }

    public Boolean getSigned() {
        return this.signed;
    }

    public boolean isZeroFill() {
        return this.zeroFill;
    }

    public void setStarPresicion(boolean starPresicion) {
        this.starPresicion = starPresicion;
    }

    public void setSigned(Boolean signed) {
        this.signed = signed;
    }

    public void setZeroFill(boolean zeroFill) {
        this.zeroFill = zeroFill;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumberType)) {
            return false;
        }
        NumberType other = (NumberType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        BigDecimal this$precision = this.getPrecision();
        BigDecimal other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        BigDecimal this$scale = this.getScale();
        BigDecimal other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        if (this.isStarPresicion() != other.isStarPresicion()) {
            return false;
        }
        Boolean this$signed = this.getSigned();
        Boolean other$signed = other.getSigned();
        if (this$signed == null ? other$signed != null : !((Object)this$signed).equals(other$signed)) {
            return false;
        }
        return this.isZeroFill() == other.isZeroFill();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NumberType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        BigDecimal $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        BigDecimal $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        result = result * 59 + (this.isStarPresicion() ? 79 : 97);
        Boolean $signed = this.getSigned();
        result = result * 59 + ($signed == null ? 43 : ((Object)$signed).hashCode());
        result = result * 59 + (this.isZeroFill() ? 79 : 97);
        return result;
    }
}

