/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common.mysql;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class LobStorageOption
extends BaseStatement {
    private final String columnName;
    private final List<String> lobChunkSizes;

    public LobStorageOption(@NonNull ParserRuleContext context, @NonNull String columnName, @NonNull List<String> lobChunkSizes) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (columnName == null) {
            throw new NullPointerException("columnName is marked non-null but is null");
        }
        if (lobChunkSizes == null) {
            throw new NullPointerException("lobChunkSizes is marked non-null but is null");
        }
        this.columnName = columnName;
        this.lobChunkSizes = lobChunkSizes;
    }

    public LobStorageOption(@NonNull String columnName, @NonNull List<String> lobChunkSizes) {
        if (columnName == null) {
            throw new NullPointerException("columnName is marked non-null but is null");
        }
        if (lobChunkSizes == null) {
            throw new NullPointerException("lobChunkSizes is marked non-null but is null");
        }
        this.columnName = columnName;
        this.lobChunkSizes = lobChunkSizes;
    }

    public String toString() {
        String lobChunkSize = this.lobChunkSizes.stream().map(s -> "CHUNK " + s).collect(Collectors.joining(" "));
        return "JSON(" + this.columnName + ") STORE AS (" + lobChunkSize + ")";
    }

    public String getColumnName() {
        return this.columnName;
    }

    public List<String> getLobChunkSizes() {
        return this.lobChunkSizes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LobStorageOption)) {
            return false;
        }
        LobStorageOption other = (LobStorageOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        List<String> this$lobChunkSizes = this.getLobChunkSizes();
        List<String> other$lobChunkSizes = other.getLobChunkSizes();
        return !(this$lobChunkSizes == null ? other$lobChunkSizes != null : !((Object)this$lobChunkSizes).equals(other$lobChunkSizes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LobStorageOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        List<String> $lobChunkSizes = this.getLobChunkSizes();
        result = result * 59 + ($lobChunkSizes == null ? 43 : ((Object)$lobChunkSizes).hashCode());
        return result;
    }
}

