/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.common.oracle;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class LogErrors
extends BaseStatement {
    private RelationFactor into;
    private Expression expression;
    private Integer rejectLimit;
    private Boolean unlimitedReject;

    public LogErrors(@NonNull ParserRuleContext context) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LOG ERRORS");
        if (this.into != null) {
            builder.append(" INTO ").append(this.into);
        }
        if (this.expression != null) {
            builder.append(" (").append(this.expression).append(")");
        }
        if (Boolean.TRUE.equals(this.unlimitedReject)) {
            builder.append(" REJECT LIMIT UNLIMITED");
        } else if (Boolean.FALSE.equals(this.unlimitedReject) && this.rejectLimit != null) {
            builder.append(" REJECT LIMIT ").append(this.rejectLimit);
        }
        return builder.toString();
    }

    public RelationFactor getInto() {
        return this.into;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Integer getRejectLimit() {
        return this.rejectLimit;
    }

    public Boolean getUnlimitedReject() {
        return this.unlimitedReject;
    }

    public void setInto(RelationFactor into) {
        this.into = into;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setRejectLimit(Integer rejectLimit) {
        this.rejectLimit = rejectLimit;
    }

    public void setUnlimitedReject(Boolean unlimitedReject) {
        this.unlimitedReject = unlimitedReject;
    }

    public LogErrors() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogErrors)) {
            return false;
        }
        LogErrors other = (LogErrors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelationFactor this$into = this.getInto();
        RelationFactor other$into = other.getInto();
        if (this$into == null ? other$into != null : !((Object)this$into).equals(other$into)) {
            return false;
        }
        Expression this$expression = this.getExpression();
        Expression other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        Integer this$rejectLimit = this.getRejectLimit();
        Integer other$rejectLimit = other.getRejectLimit();
        if (this$rejectLimit == null ? other$rejectLimit != null : !((Object)this$rejectLimit).equals(other$rejectLimit)) {
            return false;
        }
        Boolean this$unlimitedReject = this.getUnlimitedReject();
        Boolean other$unlimitedReject = other.getUnlimitedReject();
        return !(this$unlimitedReject == null ? other$unlimitedReject != null : !((Object)this$unlimitedReject).equals(other$unlimitedReject));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogErrors;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationFactor $into = this.getInto();
        result = result * 59 + ($into == null ? 43 : ((Object)$into).hashCode());
        Expression $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        Integer $rejectLimit = this.getRejectLimit();
        result = result * 59 + ($rejectLimit == null ? 43 : ((Object)$rejectLimit).hashCode());
        Boolean $unlimitedReject = this.getUnlimitedReject();
        result = result * 59 + ($unlimitedReject == null ? 43 : ((Object)$unlimitedReject).hashCode());
        return result;
    }
}

