/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createmview;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.ColumnGroupElement;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.createmview.MaterializedViewOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.Partition;
import com.oceanbase.tools.sqlparser.statement.createtable.TableOptions;
import com.oceanbase.tools.sqlparser.statement.select.Select;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class CreateMaterializedView
extends BaseStatement {
    private final RelationFactor viewName;
    private final Select asSelect;
    private List<String> columns;
    private OutOfLineConstraint primaryKey;
    private TableOptions tableOptions;
    private Partition partition;
    private String withOption;
    private List<ColumnGroupElement> columnGroupElements;
    private MaterializedViewOptions viewOptions;

    public CreateMaterializedView(@NonNull ParserRuleContext context, @NonNull RelationFactor viewName, @NonNull Select asSelect) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (viewName == null) {
            throw new NullPointerException("viewName is marked non-null but is null");
        }
        if (asSelect == null) {
            throw new NullPointerException("asSelect is marked non-null but is null");
        }
        this.viewName = viewName;
        this.asSelect = asSelect;
    }

    public CreateMaterializedView(@NonNull RelationFactor viewName, @NonNull Select asSelect) {
        if (viewName == null) {
            throw new NullPointerException("viewName is marked non-null but is null");
        }
        if (asSelect == null) {
            throw new NullPointerException("asSelect is marked non-null but is null");
        }
        this.viewName = viewName;
        this.asSelect = asSelect;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CREATE MATERIALIZED VIEW").append(" ").append(this.viewName);
        if (CollectionUtils.isNotEmpty(this.columns) || this.primaryKey != null) {
            builder.append(" (");
            if (CollectionUtils.isNotEmpty(this.columns)) {
                builder.append(String.join((CharSequence)",\n\t", this.columns));
            }
            if (this.primaryKey != null) {
                if (CollectionUtils.isNotEmpty(this.columns)) {
                    builder.append(", ");
                }
                builder.append(this.primaryKey);
            }
            builder.append(")");
        }
        if (this.tableOptions != null) {
            builder.append(" ").append(this.tableOptions);
        }
        if (this.partition != null) {
            builder.append(" ").append(this.partition);
        }
        if (CollectionUtils.isNotEmpty(this.columnGroupElements)) {
            builder.append(" WITH COLUMN GROUP (").append(this.columnGroupElements.stream().map(ColumnGroupElement::toString).collect(Collectors.joining(", "))).append(")");
        }
        if (this.viewOptions != null) {
            builder.append(" ").append(this.viewOptions);
        }
        builder.append(" AS ").append(this.asSelect);
        if (this.withOption != null) {
            builder.append(" ").append(this.withOption);
        }
        return builder.toString();
    }

    public RelationFactor getViewName() {
        return this.viewName;
    }

    public Select getAsSelect() {
        return this.asSelect;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public OutOfLineConstraint getPrimaryKey() {
        return this.primaryKey;
    }

    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public String getWithOption() {
        return this.withOption;
    }

    public List<ColumnGroupElement> getColumnGroupElements() {
        return this.columnGroupElements;
    }

    public MaterializedViewOptions getViewOptions() {
        return this.viewOptions;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public void setPrimaryKey(OutOfLineConstraint primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setTableOptions(TableOptions tableOptions) {
        this.tableOptions = tableOptions;
    }

    public void setPartition(Partition partition) {
        this.partition = partition;
    }

    public void setWithOption(String withOption) {
        this.withOption = withOption;
    }

    public void setColumnGroupElements(List<ColumnGroupElement> columnGroupElements) {
        this.columnGroupElements = columnGroupElements;
    }

    public void setViewOptions(MaterializedViewOptions viewOptions) {
        this.viewOptions = viewOptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateMaterializedView)) {
            return false;
        }
        CreateMaterializedView other = (CreateMaterializedView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelationFactor this$viewName = this.getViewName();
        RelationFactor other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !((Object)this$viewName).equals(other$viewName)) {
            return false;
        }
        Select this$asSelect = this.getAsSelect();
        Select other$asSelect = other.getAsSelect();
        if (this$asSelect == null ? other$asSelect != null : !((Object)this$asSelect).equals(other$asSelect)) {
            return false;
        }
        List<String> this$columns = this.getColumns();
        List<String> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        OutOfLineConstraint this$primaryKey = this.getPrimaryKey();
        OutOfLineConstraint other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !((Object)this$primaryKey).equals(other$primaryKey)) {
            return false;
        }
        TableOptions this$tableOptions = this.getTableOptions();
        TableOptions other$tableOptions = other.getTableOptions();
        if (this$tableOptions == null ? other$tableOptions != null : !((Object)this$tableOptions).equals(other$tableOptions)) {
            return false;
        }
        Partition this$partition = this.getPartition();
        Partition other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !this$partition.equals(other$partition)) {
            return false;
        }
        String this$withOption = this.getWithOption();
        String other$withOption = other.getWithOption();
        if (this$withOption == null ? other$withOption != null : !this$withOption.equals(other$withOption)) {
            return false;
        }
        List<ColumnGroupElement> this$columnGroupElements = this.getColumnGroupElements();
        List<ColumnGroupElement> other$columnGroupElements = other.getColumnGroupElements();
        if (this$columnGroupElements == null ? other$columnGroupElements != null : !((Object)this$columnGroupElements).equals(other$columnGroupElements)) {
            return false;
        }
        MaterializedViewOptions this$viewOptions = this.getViewOptions();
        MaterializedViewOptions other$viewOptions = other.getViewOptions();
        return !(this$viewOptions == null ? other$viewOptions != null : !((Object)this$viewOptions).equals(other$viewOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateMaterializedView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationFactor $viewName = this.getViewName();
        result = result * 59 + ($viewName == null ? 43 : ((Object)$viewName).hashCode());
        Select $asSelect = this.getAsSelect();
        result = result * 59 + ($asSelect == null ? 43 : ((Object)$asSelect).hashCode());
        List<String> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        OutOfLineConstraint $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : ((Object)$primaryKey).hashCode());
        TableOptions $tableOptions = this.getTableOptions();
        result = result * 59 + ($tableOptions == null ? 43 : ((Object)$tableOptions).hashCode());
        Partition $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
        String $withOption = this.getWithOption();
        result = result * 59 + ($withOption == null ? 43 : $withOption.hashCode());
        List<ColumnGroupElement> $columnGroupElements = this.getColumnGroupElements();
        result = result * 59 + ($columnGroupElements == null ? 43 : ((Object)$columnGroupElements).hashCode());
        MaterializedViewOptions $viewOptions = this.getViewOptions();
        result = result * 59 + ($viewOptions == null ? 43 : ((Object)$viewOptions).hashCode());
        return result;
    }
}

