/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createmview;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.createmview.MaterializedViewRefreshOption;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class MaterializedViewOptions
extends BaseStatement {
    private Boolean enableQueryWrite;
    private Boolean enableQueryComputation;
    private MaterializedViewRefreshOption refreshOption;

    public MaterializedViewOptions(@NonNull ParserRuleContext context, @NonNull MaterializedViewRefreshOption refreshOption) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (refreshOption == null) {
            throw new NullPointerException("refreshOption is marked non-null but is null");
        }
        this.refreshOption = refreshOption;
    }

    public MaterializedViewOptions(@NonNull MaterializedViewRefreshOption refreshOption) {
        if (refreshOption == null) {
            throw new NullPointerException("refreshOption is marked non-null but is null");
        }
        this.refreshOption = refreshOption;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.refreshOption.toString());
        if (Boolean.TRUE.equals(this.enableQueryWrite)) {
            builder.append(" ENABLE QUERY REWRITE");
        } else if (Boolean.FALSE.equals(this.enableQueryWrite)) {
            builder.append(" DISABLE QUERY REWRITE");
        }
        if (Boolean.TRUE.equals(this.enableQueryComputation)) {
            builder.append(" ENABLE ON QUERY COMPUTATION");
        } else if (Boolean.FALSE.equals(this.enableQueryComputation)) {
            builder.append(" DISABLE ON QUERY COMPUTATION");
        }
        return builder.toString();
    }

    public Boolean getEnableQueryWrite() {
        return this.enableQueryWrite;
    }

    public Boolean getEnableQueryComputation() {
        return this.enableQueryComputation;
    }

    public MaterializedViewRefreshOption getRefreshOption() {
        return this.refreshOption;
    }

    public void setEnableQueryWrite(Boolean enableQueryWrite) {
        this.enableQueryWrite = enableQueryWrite;
    }

    public void setEnableQueryComputation(Boolean enableQueryComputation) {
        this.enableQueryComputation = enableQueryComputation;
    }

    public void setRefreshOption(MaterializedViewRefreshOption refreshOption) {
        this.refreshOption = refreshOption;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterializedViewOptions)) {
            return false;
        }
        MaterializedViewOptions other = (MaterializedViewOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enableQueryWrite = this.getEnableQueryWrite();
        Boolean other$enableQueryWrite = other.getEnableQueryWrite();
        if (this$enableQueryWrite == null ? other$enableQueryWrite != null : !((Object)this$enableQueryWrite).equals(other$enableQueryWrite)) {
            return false;
        }
        Boolean this$enableQueryComputation = this.getEnableQueryComputation();
        Boolean other$enableQueryComputation = other.getEnableQueryComputation();
        if (this$enableQueryComputation == null ? other$enableQueryComputation != null : !((Object)this$enableQueryComputation).equals(other$enableQueryComputation)) {
            return false;
        }
        MaterializedViewRefreshOption this$refreshOption = this.getRefreshOption();
        MaterializedViewRefreshOption other$refreshOption = other.getRefreshOption();
        return !(this$refreshOption == null ? other$refreshOption != null : !((Object)this$refreshOption).equals(other$refreshOption));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaterializedViewOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enableQueryWrite = this.getEnableQueryWrite();
        result = result * 59 + ($enableQueryWrite == null ? 43 : ((Object)$enableQueryWrite).hashCode());
        Boolean $enableQueryComputation = this.getEnableQueryComputation();
        result = result * 59 + ($enableQueryComputation == null ? 43 : ((Object)$enableQueryComputation).hashCode());
        MaterializedViewRefreshOption $refreshOption = this.getRefreshOption();
        result = result * 59 + ($refreshOption == null ? 43 : ((Object)$refreshOption).hashCode());
        return result;
    }
}

