/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createmview;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class MaterializedViewRefreshOption
extends BaseStatement {
    private final boolean neverRefresh;
    private final String refreshMethod;
    private String refreshMode;
    private Expression next;
    private Expression startWith;

    public MaterializedViewRefreshOption(@NonNull ParserRuleContext context, boolean neverRefresh, String refreshMethod) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.neverRefresh = neverRefresh;
        this.refreshMethod = refreshMethod;
    }

    public MaterializedViewRefreshOption(boolean neverRefresh, String refreshMethod) {
        this.neverRefresh = neverRefresh;
        this.refreshMethod = refreshMethod;
    }

    public String toString() {
        if (this.neverRefresh) {
            return "NEVER REFRESH";
        }
        StringBuilder builder = new StringBuilder("REFRESH ").append(this.refreshMethod);
        if (this.refreshMode != null) {
            builder.append(" ON ").append(this.refreshMode);
        }
        if (this.startWith != null) {
            builder.append(" START WITH ").append(this.startWith);
        }
        if (this.next != null) {
            builder.append(" NEXT ").append(this.next);
        }
        return builder.toString();
    }

    public boolean isNeverRefresh() {
        return this.neverRefresh;
    }

    public String getRefreshMethod() {
        return this.refreshMethod;
    }

    public String getRefreshMode() {
        return this.refreshMode;
    }

    public Expression getNext() {
        return this.next;
    }

    public Expression getStartWith() {
        return this.startWith;
    }

    public void setRefreshMode(String refreshMode) {
        this.refreshMode = refreshMode;
    }

    public void setNext(Expression next) {
        this.next = next;
    }

    public void setStartWith(Expression startWith) {
        this.startWith = startWith;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterializedViewRefreshOption)) {
            return false;
        }
        MaterializedViewRefreshOption other = (MaterializedViewRefreshOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNeverRefresh() != other.isNeverRefresh()) {
            return false;
        }
        String this$refreshMethod = this.getRefreshMethod();
        String other$refreshMethod = other.getRefreshMethod();
        if (this$refreshMethod == null ? other$refreshMethod != null : !this$refreshMethod.equals(other$refreshMethod)) {
            return false;
        }
        String this$refreshMode = this.getRefreshMode();
        String other$refreshMode = other.getRefreshMode();
        if (this$refreshMode == null ? other$refreshMode != null : !this$refreshMode.equals(other$refreshMode)) {
            return false;
        }
        Expression this$next = this.getNext();
        Expression other$next = other.getNext();
        if (this$next == null ? other$next != null : !this$next.equals(other$next)) {
            return false;
        }
        Expression this$startWith = this.getStartWith();
        Expression other$startWith = other.getStartWith();
        return !(this$startWith == null ? other$startWith != null : !this$startWith.equals(other$startWith));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaterializedViewRefreshOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNeverRefresh() ? 79 : 97);
        String $refreshMethod = this.getRefreshMethod();
        result = result * 59 + ($refreshMethod == null ? 43 : $refreshMethod.hashCode());
        String $refreshMode = this.getRefreshMode();
        result = result * 59 + ($refreshMode == null ? 43 : $refreshMode.hashCode());
        Expression $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : $next.hashCode());
        Expression $startWith = this.getStartWith();
        result = result * 59 + ($startWith == null ? 43 : $startWith.hashCode());
        return result;
    }
}

