/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.Partition;
import com.oceanbase.tools.sqlparser.statement.createtable.PartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionOption;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

abstract class BasePartition
extends BaseStatement
implements Partition {
    private final List<? extends Expression> targets;
    private final List<? extends PartitionElement> elements;
    private final Integer partitionsNum;
    private final SubPartitionOption subPartitionOption;

    public BasePartition(@NonNull ParserRuleContext context, List<? extends Expression> targets, List<? extends PartitionElement> elements, SubPartitionOption subPartitionOption, Integer partitionsNum) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.partitionsNum = partitionsNum;
        this.subPartitionOption = subPartitionOption;
        this.targets = targets;
        this.elements = elements;
    }

    public BasePartition(List<? extends Expression> targets, List<? extends PartitionElement> elements, SubPartitionOption subPartitionOption, Integer partitionsNum) {
        this.partitionsNum = partitionsNum;
        this.subPartitionOption = subPartitionOption;
        this.targets = targets;
        this.elements = elements;
    }

    @Override
    public List<? extends Expression> getPartitionTargets() {
        return this.targets;
    }

    @Override
    public SubPartitionOption getSubPartitionOption() {
        return this.subPartitionOption;
    }

    @Override
    public Integer getPartitionsNum() {
        return this.partitionsNum;
    }

    @Override
    public List<? extends PartitionElement> getPartitionElements() {
        return CollectionUtils.isEmpty(this.elements) ? Collections.emptyList() : this.elements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePartition)) {
            return false;
        }
        BasePartition other = (BasePartition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<? extends Expression> this$targets = this.targets;
        List<? extends Expression> other$targets = other.targets;
        if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
            return false;
        }
        List<? extends PartitionElement> this$elements = this.elements;
        List<? extends PartitionElement> other$elements = other.elements;
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        Integer this$partitionsNum = this.getPartitionsNum();
        Integer other$partitionsNum = other.getPartitionsNum();
        if (this$partitionsNum == null ? other$partitionsNum != null : !((Object)this$partitionsNum).equals(other$partitionsNum)) {
            return false;
        }
        SubPartitionOption this$subPartitionOption = this.getSubPartitionOption();
        SubPartitionOption other$subPartitionOption = other.getSubPartitionOption();
        return !(this$subPartitionOption == null ? other$subPartitionOption != null : !((Object)this$subPartitionOption).equals(other$subPartitionOption));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasePartition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<? extends Expression> $targets = this.targets;
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        List<? extends PartitionElement> $elements = this.elements;
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        Integer $partitionsNum = this.getPartitionsNum();
        result = result * 59 + ($partitionsNum == null ? 43 : ((Object)$partitionsNum).hashCode());
        SubPartitionOption $subPartitionOption = this.getSubPartitionOption();
        result = result * 59 + ($subPartitionOption == null ? 43 : ((Object)$subPartitionOption).hashCode());
        return result;
    }
}

