/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.createtable.PartitionOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionElement;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

abstract class BaseSubPartitionElement
extends BaseStatement
implements SubPartitionElement {
    private String userVariable;
    private String schema;
    private PartitionOptions partitionOptions;
    private final String relation;

    public BaseSubPartitionElement(@NonNull ParserRuleContext context, String relation) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.relation = relation;
    }

    public BaseSubPartitionElement(String relation) {
        this.relation = relation;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getRelation() {
        return this.relation;
    }

    @Override
    public PartitionOptions getOptions() {
        return this.partitionOptions;
    }

    public String getRelationFactor() {
        StringBuilder builder = new StringBuilder();
        if (this.schema != null) {
            builder.append(" ").append(this.schema).append(".").append(this.relation);
        } else if (this.relation != null) {
            builder.append(" ").append(this.relation);
        }
        if (this.userVariable != null) {
            builder.append(this.userVariable);
        }
        return builder.length() == 0 ? null : builder.substring(1);
    }

    public void setUserVariable(String userVariable) {
        this.userVariable = userVariable;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setPartitionOptions(PartitionOptions partitionOptions) {
        this.partitionOptions = partitionOptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseSubPartitionElement)) {
            return false;
        }
        BaseSubPartitionElement other = (BaseSubPartitionElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userVariable = this.getUserVariable();
        String other$userVariable = other.getUserVariable();
        if (this$userVariable == null ? other$userVariable != null : !this$userVariable.equals(other$userVariable)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        PartitionOptions this$partitionOptions = this.partitionOptions;
        PartitionOptions other$partitionOptions = other.partitionOptions;
        if (this$partitionOptions == null ? other$partitionOptions != null : !((Object)this$partitionOptions).equals(other$partitionOptions)) {
            return false;
        }
        String this$relation = this.getRelation();
        String other$relation = other.getRelation();
        return !(this$relation == null ? other$relation != null : !this$relation.equals(other$relation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseSubPartitionElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userVariable = this.getUserVariable();
        result = result * 59 + ($userVariable == null ? 43 : $userVariable.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        PartitionOptions $partitionOptions = this.partitionOptions;
        result = result * 59 + ($partitionOptions == null ? 43 : ((Object)$partitionOptions).hashCode());
        String $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
        return result;
    }

    public String getUserVariable() {
        return this.userVariable;
    }
}

