/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.BaseOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.InLineCheckConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.InLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.InLineForeignConstraint;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class ColumnAttributes
extends BaseOptions {
    private Expression defaultValue;
    private Expression origDefault;
    private Boolean autoIncrement;
    private Integer id;
    private String comment;
    private Expression onUpdate;
    private String collation;
    private Integer srid;
    private String lobChunkSize;
    private String columnFormat;
    private String storage;
    private List<InLineConstraint> constraints;
    private List<String> skipIndexTypes;

    public ColumnAttributes(@NonNull ParserRuleContext context) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    @Override
    protected void doMerge(PropertyDescriptor pd, Object otherVal) throws InvocationTargetException, IllegalAccessException {
        if (!"constraints".equals(pd.getName()) || this.constraints == null) {
            super.doMerge(pd, otherVal);
        } else {
            this.constraints = new ArrayList<InLineConstraint>(this.constraints);
            this.constraints.addAll((List)otherVal);
        }
    }

    public List<InLineCheckConstraint> getCheckConstraints() {
        if (CollectionUtils.isEmpty(this.constraints)) {
            return Collections.emptyList();
        }
        return this.constraints.stream().filter(c -> c instanceof InLineCheckConstraint).map(c -> (InLineCheckConstraint)c).collect(Collectors.toList());
    }

    public List<InLineForeignConstraint> getForeignConstraints() {
        if (CollectionUtils.isEmpty(this.constraints)) {
            return Collections.emptyList();
        }
        return this.constraints.stream().filter(c -> c instanceof InLineForeignConstraint).map(c -> (InLineForeignConstraint)c).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (Boolean.TRUE.equals(this.autoIncrement)) {
            builder.append(" AUTO_INCREMENT");
        }
        if (this.defaultValue != null) {
            builder.append(" DEFAULT ").append(this.defaultValue);
        }
        if (this.origDefault != null) {
            builder.append(" ORIG_DEFAULT ").append(this.origDefault);
        }
        if (this.id != null) {
            builder.append(" ID ").append(this.id);
        }
        if (this.comment != null) {
            builder.append(" COMMENT ").append(this.comment);
        }
        if (this.onUpdate != null) {
            builder.append(" ON UPDATE ").append(this.onUpdate);
        }
        if (CollectionUtils.isNotEmpty(this.constraints)) {
            builder.append(" ").append(this.constraints.stream().map(InLineConstraint::toString).collect(Collectors.joining(" ")));
        }
        if (this.srid != null) {
            builder.append(" SRID ").append(this.srid);
        }
        if (this.collation != null) {
            builder.append(" COLLATE ").append(this.collation);
        }
        if (this.skipIndexTypes != null) {
            builder.append(" SKIP_INDEX (").append(String.join((CharSequence)",", this.skipIndexTypes)).append(")");
        }
        if (this.lobChunkSize != null) {
            builder.append(" CHUNK ").append(this.lobChunkSize);
        }
        if (this.columnFormat != null) {
            builder.append(" COLUMN_FORMAT ").append(this.columnFormat);
        }
        if (this.storage != null) {
            builder.append(" STORAGE ").append(this.storage);
        }
        return builder.length() == 0 ? "" : builder.substring(1);
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public Expression getOrigDefault() {
        return this.origDefault;
    }

    public Boolean getAutoIncrement() {
        return this.autoIncrement;
    }

    public Integer getId() {
        return this.id;
    }

    public String getComment() {
        return this.comment;
    }

    public Expression getOnUpdate() {
        return this.onUpdate;
    }

    public String getCollation() {
        return this.collation;
    }

    public Integer getSrid() {
        return this.srid;
    }

    public String getLobChunkSize() {
        return this.lobChunkSize;
    }

    public String getColumnFormat() {
        return this.columnFormat;
    }

    public String getStorage() {
        return this.storage;
    }

    public List<InLineConstraint> getConstraints() {
        return this.constraints;
    }

    public List<String> getSkipIndexTypes() {
        return this.skipIndexTypes;
    }

    public void setDefaultValue(Expression defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setOrigDefault(Expression origDefault) {
        this.origDefault = origDefault;
    }

    public void setAutoIncrement(Boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setOnUpdate(Expression onUpdate) {
        this.onUpdate = onUpdate;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public void setSrid(Integer srid) {
        this.srid = srid;
    }

    public void setLobChunkSize(String lobChunkSize) {
        this.lobChunkSize = lobChunkSize;
    }

    public void setColumnFormat(String columnFormat) {
        this.columnFormat = columnFormat;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public void setConstraints(List<InLineConstraint> constraints) {
        this.constraints = constraints;
    }

    public void setSkipIndexTypes(List<String> skipIndexTypes) {
        this.skipIndexTypes = skipIndexTypes;
    }

    public ColumnAttributes() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnAttributes)) {
            return false;
        }
        ColumnAttributes other = (ColumnAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$defaultValue = this.getDefaultValue();
        Expression other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        Expression this$origDefault = this.getOrigDefault();
        Expression other$origDefault = other.getOrigDefault();
        if (this$origDefault == null ? other$origDefault != null : !this$origDefault.equals(other$origDefault)) {
            return false;
        }
        Boolean this$autoIncrement = this.getAutoIncrement();
        Boolean other$autoIncrement = other.getAutoIncrement();
        if (this$autoIncrement == null ? other$autoIncrement != null : !((Object)this$autoIncrement).equals(other$autoIncrement)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Expression this$onUpdate = this.getOnUpdate();
        Expression other$onUpdate = other.getOnUpdate();
        if (this$onUpdate == null ? other$onUpdate != null : !this$onUpdate.equals(other$onUpdate)) {
            return false;
        }
        String this$collation = this.getCollation();
        String other$collation = other.getCollation();
        if (this$collation == null ? other$collation != null : !this$collation.equals(other$collation)) {
            return false;
        }
        Integer this$srid = this.getSrid();
        Integer other$srid = other.getSrid();
        if (this$srid == null ? other$srid != null : !((Object)this$srid).equals(other$srid)) {
            return false;
        }
        String this$lobChunkSize = this.getLobChunkSize();
        String other$lobChunkSize = other.getLobChunkSize();
        if (this$lobChunkSize == null ? other$lobChunkSize != null : !this$lobChunkSize.equals(other$lobChunkSize)) {
            return false;
        }
        String this$columnFormat = this.getColumnFormat();
        String other$columnFormat = other.getColumnFormat();
        if (this$columnFormat == null ? other$columnFormat != null : !this$columnFormat.equals(other$columnFormat)) {
            return false;
        }
        String this$storage = this.getStorage();
        String other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        List<InLineConstraint> this$constraints = this.getConstraints();
        List<InLineConstraint> other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints)) {
            return false;
        }
        List<String> this$skipIndexTypes = this.getSkipIndexTypes();
        List<String> other$skipIndexTypes = other.getSkipIndexTypes();
        return !(this$skipIndexTypes == null ? other$skipIndexTypes != null : !((Object)this$skipIndexTypes).equals(other$skipIndexTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnAttributes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        Expression $origDefault = this.getOrigDefault();
        result = result * 59 + ($origDefault == null ? 43 : $origDefault.hashCode());
        Boolean $autoIncrement = this.getAutoIncrement();
        result = result * 59 + ($autoIncrement == null ? 43 : ((Object)$autoIncrement).hashCode());
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Expression $onUpdate = this.getOnUpdate();
        result = result * 59 + ($onUpdate == null ? 43 : $onUpdate.hashCode());
        String $collation = this.getCollation();
        result = result * 59 + ($collation == null ? 43 : $collation.hashCode());
        Integer $srid = this.getSrid();
        result = result * 59 + ($srid == null ? 43 : ((Object)$srid).hashCode());
        String $lobChunkSize = this.getLobChunkSize();
        result = result * 59 + ($lobChunkSize == null ? 43 : $lobChunkSize.hashCode());
        String $columnFormat = this.getColumnFormat();
        result = result * 59 + ($columnFormat == null ? 43 : $columnFormat.hashCode());
        String $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        List<InLineConstraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        List<String> $skipIndexTypes = this.getSkipIndexTypes();
        result = result * 59 + ($skipIndexTypes == null ? 43 : ((Object)$skipIndexTypes).hashCode());
        return result;
    }
}

