/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.DataType;
import com.oceanbase.tools.sqlparser.statement.createtable.ColumnAttributes;
import com.oceanbase.tools.sqlparser.statement.createtable.ForeignReference;
import com.oceanbase.tools.sqlparser.statement.createtable.GenerateOption;
import com.oceanbase.tools.sqlparser.statement.createtable.TableElement;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class ColumnDefinition
extends BaseStatement
implements TableElement {
    private ColumnAttributes columnAttributes;
    private Boolean visible;
    private Location location;
    private boolean serial;
    private GenerateOption generateOption;
    private ForeignReference foreignReference;
    private final DataType dataType;
    private final ColumnReference columnReference;

    public ColumnDefinition(@NonNull ParserRuleContext context, @NonNull ColumnReference columnReference, DataType dataType) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (columnReference == null) {
            throw new NullPointerException("columnReference is marked non-null but is null");
        }
        this.dataType = dataType;
        this.columnReference = columnReference;
    }

    public ColumnDefinition(@NonNull ColumnReference columnReference, DataType dataType) {
        if (columnReference == null) {
            throw new NullPointerException("columnReference is marked non-null but is null");
        }
        this.dataType = dataType;
        this.columnReference = columnReference;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.columnReference.toString());
        if (this.dataType != null) {
            builder.append(" ").append(this.dataType.toString());
        } else if (this.serial) {
            builder.append(" SERIAL");
        }
        if (this.visible != null) {
            if (this.visible.booleanValue()) {
                builder.append(" ").append("VISIBLE");
            } else {
                builder.append(" ").append("INVISIBLE");
            }
        }
        if (this.generateOption != null) {
            builder.append(" ").append(this.generateOption.toString());
        }
        if (this.columnAttributes != null) {
            builder.append(" ").append(this.columnAttributes);
        }
        if (this.foreignReference != null) {
            builder.append(" ").append(this.foreignReference);
        }
        if (this.location != null) {
            builder.append(" ").append(this.location);
        }
        return builder.toString();
    }

    public ColumnAttributes getColumnAttributes() {
        return this.columnAttributes;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean isSerial() {
        return this.serial;
    }

    public GenerateOption getGenerateOption() {
        return this.generateOption;
    }

    public ForeignReference getForeignReference() {
        return this.foreignReference;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public ColumnReference getColumnReference() {
        return this.columnReference;
    }

    public void setColumnAttributes(ColumnAttributes columnAttributes) {
        this.columnAttributes = columnAttributes;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setSerial(boolean serial) {
        this.serial = serial;
    }

    public void setGenerateOption(GenerateOption generateOption) {
        this.generateOption = generateOption;
    }

    public void setForeignReference(ForeignReference foreignReference) {
        this.foreignReference = foreignReference;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition other = (ColumnDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ColumnAttributes this$columnAttributes = this.getColumnAttributes();
        ColumnAttributes other$columnAttributes = other.getColumnAttributes();
        if (this$columnAttributes == null ? other$columnAttributes != null : !((Object)this$columnAttributes).equals(other$columnAttributes)) {
            return false;
        }
        Boolean this$visible = this.getVisible();
        Boolean other$visible = other.getVisible();
        if (this$visible == null ? other$visible != null : !((Object)this$visible).equals(other$visible)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        if (this.isSerial() != other.isSerial()) {
            return false;
        }
        GenerateOption this$generateOption = this.getGenerateOption();
        GenerateOption other$generateOption = other.getGenerateOption();
        if (this$generateOption == null ? other$generateOption != null : !((Object)this$generateOption).equals(other$generateOption)) {
            return false;
        }
        ForeignReference this$foreignReference = this.getForeignReference();
        ForeignReference other$foreignReference = other.getForeignReference();
        if (this$foreignReference == null ? other$foreignReference != null : !((Object)this$foreignReference).equals(other$foreignReference)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        ColumnReference this$columnReference = this.getColumnReference();
        ColumnReference other$columnReference = other.getColumnReference();
        return !(this$columnReference == null ? other$columnReference != null : !((Object)this$columnReference).equals(other$columnReference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ColumnAttributes $columnAttributes = this.getColumnAttributes();
        result = result * 59 + ($columnAttributes == null ? 43 : ((Object)$columnAttributes).hashCode());
        Boolean $visible = this.getVisible();
        result = result * 59 + ($visible == null ? 43 : ((Object)$visible).hashCode());
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        result = result * 59 + (this.isSerial() ? 79 : 97);
        GenerateOption $generateOption = this.getGenerateOption();
        result = result * 59 + ($generateOption == null ? 43 : ((Object)$generateOption).hashCode());
        ForeignReference $foreignReference = this.getForeignReference();
        result = result * 59 + ($foreignReference == null ? 43 : ((Object)$foreignReference).hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        ColumnReference $columnReference = this.getColumnReference();
        result = result * 59 + ($columnReference == null ? 43 : ((Object)$columnReference).hashCode());
        return result;
    }

    public static class Location {
        private final String type;
        private final ColumnReference column;

        public String toString() {
            if (this.column != null) {
                return this.type + " " + this.column;
            }
            return this.type;
        }

        public String getType() {
            return this.type;
        }

        public ColumnReference getColumn() {
            return this.column;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location other = (Location)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            ColumnReference this$column = this.getColumn();
            ColumnReference other$column = other.getColumn();
            return !(this$column == null ? other$column != null : !((Object)this$column).equals(other$column));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Location;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            ColumnReference $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
            return result;
        }

        public Location(String type, ColumnReference column) {
            this.type = type;
            this.column = column;
        }
    }
}

