/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.BasePartitionElement;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class ListPartitionElement
extends BasePartitionElement {
    private final List<Expression> listExprs;

    public ListPartitionElement(@NonNull ParserRuleContext context, String relation, @NonNull List<Expression> listExprs) {
        super(context, relation);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (listExprs == null) {
            throw new NullPointerException("listExprs is marked non-null but is null");
        }
        this.listExprs = listExprs;
    }

    public ListPartitionElement(String relation, @NonNull List<Expression> listExprs) {
        super(relation);
        if (listExprs == null) {
            throw new NullPointerException("listExprs is marked non-null but is null");
        }
        this.listExprs = listExprs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PARTITION");
        if (this.getRelationFactor() != null) {
            builder.append(" ").append(this.getRelationFactor());
        }
        builder.append(" VALUES(").append(this.listExprs.stream().map(Object::toString).collect(Collectors.joining(","))).append(")");
        if (this.getOptions() != null) {
            builder.append(" ").append(this.getOptions());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.getSubPartitionElements())) {
            builder.append(" (\n\t\t").append(this.getSubPartitionElements().stream().map(Object::toString).collect(Collectors.joining(",\n\t\t"))).append("\n\t)");
        }
        return builder.toString();
    }

    public List<Expression> getListExprs() {
        return this.listExprs;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListPartitionElement)) {
            return false;
        }
        ListPartitionElement other = (ListPartitionElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Expression> this$listExprs = this.getListExprs();
        List<Expression> other$listExprs = other.getListExprs();
        return !(this$listExprs == null ? other$listExprs != null : !((Object)this$listExprs).equals(other$listExprs));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListPartitionElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Expression> $listExprs = this.getListExprs();
        result = result * 59 + ($listExprs == null ? 43 : ((Object)$listExprs).hashCode());
        return result;
    }
}

