/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.ColumnGroupElement;
import com.oceanbase.tools.sqlparser.statement.createtable.IndexOptions;
import com.oceanbase.tools.sqlparser.statement.createtable.Partition;
import com.oceanbase.tools.sqlparser.statement.createtable.SortColumn;
import com.oceanbase.tools.sqlparser.statement.createtable.TableElement;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;

public class OutOfLineIndex
extends BaseStatement
implements TableElement {
    private IndexOptions indexOptions;
    private Partition partition;
    private boolean fullText;
    private boolean spatial;
    private boolean vector;
    private final String indexName;
    private final List<SortColumn> columns;
    private List<ColumnGroupElement> columnGroupElements;

    public OutOfLineIndex(@NonNull ParserRuleContext context, String indexName, @NonNull List<SortColumn> columns) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.indexName = indexName;
        this.columns = columns;
    }

    public OutOfLineIndex(String indexName, @NonNull List<SortColumn> columns) {
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.indexName = indexName;
        this.columns = columns;
    }

    public String toString() {
        StringBuilder builder = this.fullText ? new StringBuilder("FULLTEXT KEY") : (this.spatial ? new StringBuilder("SPATIAL KEY") : (this.vector ? new StringBuilder("VECTOR KEY") : new StringBuilder("INDEX")));
        if (this.indexName != null) {
            builder.append(" ").append(this.indexName);
        }
        builder.append("(").append(this.columns.stream().map(SortColumn::toString).collect(Collectors.joining(","))).append(")");
        if (this.indexOptions != null) {
            builder.append(" ").append(this.indexOptions.toString());
        }
        if (this.partition != null) {
            builder.append(" ").append(this.partition.toString());
        }
        if (this.columnGroupElements != null) {
            builder.append(" WITH COLUMN GROUP(").append(this.columnGroupElements.stream().map(ColumnGroupElement::toString).collect(Collectors.joining(","))).append(")");
        }
        return builder.toString();
    }

    public IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public boolean isFullText() {
        return this.fullText;
    }

    public boolean isSpatial() {
        return this.spatial;
    }

    public boolean isVector() {
        return this.vector;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<SortColumn> getColumns() {
        return this.columns;
    }

    public List<ColumnGroupElement> getColumnGroupElements() {
        return this.columnGroupElements;
    }

    public void setIndexOptions(IndexOptions indexOptions) {
        this.indexOptions = indexOptions;
    }

    public void setPartition(Partition partition) {
        this.partition = partition;
    }

    public void setFullText(boolean fullText) {
        this.fullText = fullText;
    }

    public void setSpatial(boolean spatial) {
        this.spatial = spatial;
    }

    public void setVector(boolean vector) {
        this.vector = vector;
    }

    public void setColumnGroupElements(List<ColumnGroupElement> columnGroupElements) {
        this.columnGroupElements = columnGroupElements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutOfLineIndex)) {
            return false;
        }
        OutOfLineIndex other = (OutOfLineIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IndexOptions this$indexOptions = this.getIndexOptions();
        IndexOptions other$indexOptions = other.getIndexOptions();
        if (this$indexOptions == null ? other$indexOptions != null : !((Object)this$indexOptions).equals(other$indexOptions)) {
            return false;
        }
        Partition this$partition = this.getPartition();
        Partition other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !this$partition.equals(other$partition)) {
            return false;
        }
        if (this.isFullText() != other.isFullText()) {
            return false;
        }
        if (this.isSpatial() != other.isSpatial()) {
            return false;
        }
        if (this.isVector() != other.isVector()) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        List<SortColumn> this$columns = this.getColumns();
        List<SortColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        List<ColumnGroupElement> this$columnGroupElements = this.getColumnGroupElements();
        List<ColumnGroupElement> other$columnGroupElements = other.getColumnGroupElements();
        return !(this$columnGroupElements == null ? other$columnGroupElements != null : !((Object)this$columnGroupElements).equals(other$columnGroupElements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OutOfLineIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IndexOptions $indexOptions = this.getIndexOptions();
        result = result * 59 + ($indexOptions == null ? 43 : ((Object)$indexOptions).hashCode());
        Partition $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
        result = result * 59 + (this.isFullText() ? 79 : 97);
        result = result * 59 + (this.isSpatial() ? 79 : 97);
        result = result * 59 + (this.isVector() ? 79 : 97);
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        List<SortColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        List<ColumnGroupElement> $columnGroupElements = this.getColumnGroupElements();
        result = result * 59 + ($columnGroupElements == null ? 43 : ((Object)$columnGroupElements).hashCode());
        return result;
    }
}

