/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.BasePartitionElement;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class RangePartitionElement
extends BasePartitionElement {
    private final List<Expression> rangeExprs;

    public RangePartitionElement(@NonNull ParserRuleContext context, String relation, @NonNull List<Expression> rangeExprs) {
        super(context, relation);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (rangeExprs == null) {
            throw new NullPointerException("rangeExprs is marked non-null but is null");
        }
        this.rangeExprs = rangeExprs;
    }

    public RangePartitionElement(String relation, @NonNull List<Expression> rangeExprs) {
        super(relation);
        if (rangeExprs == null) {
            throw new NullPointerException("rangeExprs is marked non-null but is null");
        }
        this.rangeExprs = rangeExprs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PARTITION");
        if (this.getRelationFactor() != null) {
            builder.append(" ").append(this.getRelationFactor());
        }
        builder.append(" VALUES LESS THAN(").append(this.rangeExprs.stream().map(Object::toString).collect(Collectors.joining(","))).append(")");
        if (this.getOptions() != null) {
            builder.append(" ").append(this.getOptions());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.getSubPartitionElements())) {
            builder.append(" (\n\t\t").append(this.getSubPartitionElements().stream().map(Object::toString).collect(Collectors.joining(",\n\t\t"))).append("\n\t)");
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangePartitionElement)) {
            return false;
        }
        RangePartitionElement other = (RangePartitionElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Expression> this$rangeExprs = this.getRangeExprs();
        List<Expression> other$rangeExprs = other.getRangeExprs();
        return !(this$rangeExprs == null ? other$rangeExprs != null : !((Object)this$rangeExprs).equals(other$rangeExprs));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RangePartitionElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Expression> $rangeExprs = this.getRangeExprs();
        result = result * 59 + ($rangeExprs == null ? 43 : ((Object)$rangeExprs).hashCode());
        return result;
    }

    public List<Expression> getRangeExprs() {
        return this.rangeExprs;
    }
}

