/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionElement;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class SubPartitionOption
extends BaseStatement {
    private Integer subPartitionNum;
    private List<SubPartitionElement> templates;
    private final String type;
    private final List<Expression> subPartitionTargets;

    public SubPartitionOption(@NonNull ParserRuleContext context, @NonNull List<Expression> subPartitionTargets, @NonNull String type) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (subPartitionTargets == null) {
            throw new NullPointerException("subPartitionTargets is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.subPartitionTargets = subPartitionTargets;
    }

    public SubPartitionOption(@NonNull List<Expression> subPartitionTargets, @NonNull String type) {
        if (subPartitionTargets == null) {
            throw new NullPointerException("subPartitionTargets is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.subPartitionTargets = subPartitionTargets;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SUBPARTITION BY ").append(this.type.toUpperCase());
        builder.append("(").append(this.subPartitionTargets.stream().map(Object::toString).collect(Collectors.joining(","))).append(")");
        if (CollectionUtils.isNotEmpty(this.templates)) {
            builder.append(" SUBPARTITION TEMPLATE (\n\t").append(this.templates.stream().map(Object::toString).collect(Collectors.joining(",\n\t"))).append(")");
        } else if (this.subPartitionNum != null) {
            builder.append(" SUBPARTITIONS ").append(this.subPartitionNum);
        }
        return builder.toString();
    }

    public Integer getSubPartitionNum() {
        return this.subPartitionNum;
    }

    public List<SubPartitionElement> getTemplates() {
        return this.templates;
    }

    public String getType() {
        return this.type;
    }

    public List<Expression> getSubPartitionTargets() {
        return this.subPartitionTargets;
    }

    public void setSubPartitionNum(Integer subPartitionNum) {
        this.subPartitionNum = subPartitionNum;
    }

    public void setTemplates(List<SubPartitionElement> templates) {
        this.templates = templates;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubPartitionOption)) {
            return false;
        }
        SubPartitionOption other = (SubPartitionOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$subPartitionNum = this.getSubPartitionNum();
        Integer other$subPartitionNum = other.getSubPartitionNum();
        if (this$subPartitionNum == null ? other$subPartitionNum != null : !((Object)this$subPartitionNum).equals(other$subPartitionNum)) {
            return false;
        }
        List<SubPartitionElement> this$templates = this.getTemplates();
        List<SubPartitionElement> other$templates = other.getTemplates();
        if (this$templates == null ? other$templates != null : !((Object)this$templates).equals(other$templates)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<Expression> this$subPartitionTargets = this.getSubPartitionTargets();
        List<Expression> other$subPartitionTargets = other.getSubPartitionTargets();
        return !(this$subPartitionTargets == null ? other$subPartitionTargets != null : !((Object)this$subPartitionTargets).equals(other$subPartitionTargets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubPartitionOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $subPartitionNum = this.getSubPartitionNum();
        result = result * 59 + ($subPartitionNum == null ? 43 : ((Object)$subPartitionNum).hashCode());
        List<SubPartitionElement> $templates = this.getTemplates();
        result = result * 59 + ($templates == null ? 43 : ((Object)$templates).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<Expression> $subPartitionTargets = this.getSubPartitionTargets();
        result = result * 59 + ($subPartitionTargets == null ? 43 : ((Object)$subPartitionTargets).hashCode());
        return result;
    }
}

