/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.createtable;

import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.common.BaseOptions;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.common.mysql.LobStorageOption;
import com.oceanbase.tools.sqlparser.statement.expression.BaseExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.collections4.CollectionUtils;

public class TableOptions
extends BaseOptions {
    private List<ColumnReference> sortKeys;
    private Integer parallel;
    private Boolean noParallel;
    private String tableMode;
    private String duplicateScope;
    private String locality;
    private Expression expireInfo;
    private Integer progressiveMergeNum;
    private Integer blockSize;
    private Integer tableId;
    private Integer replicaNum;
    private Boolean noCompress;
    private String compress;
    private Boolean useBloomFilter;
    private String primaryZone;
    private String tableGroup;
    private Boolean readOnly;
    private Boolean readWrite;
    private String engine;
    private Integer tabletSize;
    private Integer maxUsedPartId;
    private Boolean enableRowMovement;
    private Boolean disableRowMovement;
    private Integer pctFree;
    private Integer pctUsed;
    private Integer iniTrans;
    private Integer maxTrans;
    private List<String> storage;
    private String tableSpace;
    private String comment;
    private String compression;
    private Integer storageFormatVersion;
    private String rowFormat;
    private String charset;
    private String collation;
    private BigDecimal autoIncrement;
    private Integer delayKeyWrite;
    private Integer avgRowLength;
    private Integer checksum;
    private String autoIncrementMode;
    private Boolean enableExtendedRowId;
    private String location;
    private Map<String, Expression> format;
    private String pattern;
    private List<Expression> ttls;
    private String kvAttributes;
    private Integer defaultLobInRowThreshold;
    private Integer lobInRowThreshold;
    private Integer keyBlockSize;
    private Integer autoIncrementCacheSize;
    private String partitionType;
    private Map<String, String> externalProperties;
    private LobStorageOption lobStorageOption;
    private Boolean microIndexClustered;
    private String autoRefresh;
    private Integer maxRows;
    private Integer minRows;
    private String password;
    private String packKeys;
    private String connection;
    private String dataDirectory;
    private String indexDirectory;
    private String encryption;
    private String statsAutoRecalc;
    private String statsPersistent;
    private String statsSamplePages;
    private List<RelationFactor> union;
    private String insertMethod;
    private String organization;
    private Boolean enableMacroBlockBloomFilter;

    public TableOptions(@NonNull ParserRuleContext context) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.sortKeys != null) {
            builder.append(" SORTKEY(").append(this.sortKeys.stream().map(BaseExpression::toString).collect(Collectors.joining(","))).append(")");
        }
        if (this.parallel != null) {
            builder.append(" PARALLEL=").append(this.parallel);
        }
        if (Boolean.TRUE.equals(this.noParallel)) {
            builder.append(" NOPARALLEL");
        }
        if (this.tableMode != null) {
            builder.append(" TABLE_MODE=").append(this.tableMode);
        }
        if (this.duplicateScope != null) {
            builder.append(" DUPLICATE_SCOPE=").append(this.duplicateScope);
        }
        if (this.locality != null) {
            builder.append(" LOCALITY=").append(this.locality);
        }
        if (this.expireInfo != null) {
            builder.append(" EXPIRE_INFO=(").append(this.expireInfo).append(")");
        }
        if (this.progressiveMergeNum != null) {
            builder.append(" PROGRESSIVE_MERGE_NUM=").append(this.progressiveMergeNum);
        }
        if (this.blockSize != null) {
            builder.append(" BLOCK_SIZE=").append(this.blockSize);
        }
        if (this.tableId != null) {
            builder.append(" TABLE_ID=").append(this.tableId);
        }
        if (this.replicaNum != null) {
            builder.append(" REPLICA_NUM=").append(this.replicaNum);
        }
        if (Boolean.TRUE.equals(this.noCompress)) {
            builder.append(" NOCOMPRESS");
        }
        if (this.compress != null) {
            builder.append(" COMPRESS ").append(this.compress);
        }
        if (this.useBloomFilter != null) {
            builder.append(" USE_BLOOM_FILTER=").append(this.useBloomFilter != false ? "TRUE" : "FALSE");
        }
        if (this.primaryZone != null) {
            builder.append(" PRIMARY_ZONE=").append(this.primaryZone);
        }
        if (this.tableGroup != null) {
            builder.append(" TABLEGROUP=").append(this.tableGroup);
        }
        if (Boolean.TRUE.equals(this.readOnly)) {
            builder.append(" READ ONLY");
        }
        if (Boolean.TRUE.equals(this.readWrite)) {
            builder.append(" READ WRITE");
        }
        if (this.engine != null) {
            builder.append(" ENGINE=").append(this.engine);
        }
        if (this.tabletSize != null) {
            builder.append(" TABLET_SIZE=").append(this.tabletSize);
        }
        if (this.maxUsedPartId != null) {
            builder.append(" MAX_USED_PART_ID=").append(this.maxUsedPartId);
        }
        if (Boolean.TRUE.equals(this.enableRowMovement)) {
            builder.append(" ENABLE ROW MOVEMENT");
        }
        if (Boolean.TRUE.equals(this.disableRowMovement)) {
            builder.append(" DISABLE ROW MOVEMENT");
        }
        if (this.pctFree != null) {
            builder.append(" PCTFREE=").append(this.pctFree);
        }
        if (this.pctUsed != null) {
            builder.append(" PCTUSED ").append(this.pctUsed);
        }
        if (this.iniTrans != null) {
            builder.append(" INITRANS ").append(this.iniTrans);
        }
        if (this.maxTrans != null) {
            builder.append(" MAXTRANS ").append(this.maxTrans);
        }
        if (this.storage != null) {
            builder.append(" STORAGE(").append(String.join((CharSequence)" ", this.storage)).append(")");
        }
        if (this.tableSpace != null) {
            builder.append(" TABLESPACE ").append(this.tableSpace);
        }
        if (this.comment != null) {
            builder.append(" COMMENT ").append(this.comment);
        }
        if (this.compression != null) {
            builder.append(" COMPRESSION=").append(this.compression);
        }
        if (this.storageFormatVersion != null) {
            builder.append(" STORAGE_FORMAT_VERSION=").append(this.storageFormatVersion);
        }
        if (this.rowFormat != null) {
            builder.append(" ROW_FORMAT=").append(this.rowFormat);
        }
        if (this.charset != null) {
            builder.append(" CHARSET=").append(this.charset);
        }
        if (this.collation != null) {
            builder.append(" COLLATE=").append(this.collation);
        }
        if (this.autoIncrement != null) {
            builder.append(" AUTO_INCREMENT=").append(this.autoIncrement.toString());
        }
        if (this.delayKeyWrite != null) {
            builder.append(" DELAY_KEY_WRITE=").append(this.delayKeyWrite);
        }
        if (this.avgRowLength != null) {
            builder.append(" AVG_ROW_LENGTH=").append(this.avgRowLength);
        }
        if (this.checksum != null) {
            builder.append(" CHECKSUM=").append(this.checksum);
        }
        if (this.autoIncrementMode != null) {
            builder.append(" AUTO_INCREMENT_MODE=").append(this.autoIncrementMode);
        }
        if (this.enableExtendedRowId != null) {
            builder.append(" ENABLE_EXTENDED_ROWID=").append(this.enableExtendedRowId != false ? "TRUE" : "FALSE");
        }
        if (this.location != null) {
            builder.append(" LOCATION=").append(this.location);
        }
        if (this.format != null) {
            builder.append(" FORMAT=(").append(this.format.entrySet().stream().map(e -> (String)e.getKey() + "=" + ((Expression)e.getValue()).toString()).collect(Collectors.joining(","))).append(")");
        }
        if (this.pattern != null) {
            builder.append(" PATTERN=").append(this.pattern);
        }
        if (CollectionUtils.isNotEmpty(this.ttls)) {
            builder.append(" TTL(").append(this.ttls.stream().map(Object::toString).collect(Collectors.joining(","))).append(")");
        }
        if (this.kvAttributes != null) {
            builder.append(" KV_ATTRIBUTES=").append(this.kvAttributes);
        }
        if (this.defaultLobInRowThreshold != null) {
            builder.append(" DEFAULT_LOB_INROW_THRESHOLD=").append(this.defaultLobInRowThreshold);
        }
        if (this.lobInRowThreshold != null) {
            builder.append(" LOB_INROW_THRESHOLD=").append(this.lobInRowThreshold);
        }
        if (this.keyBlockSize != null) {
            builder.append(" KEY_BLOCK_SIZE=").append(this.keyBlockSize);
        }
        if (this.autoIncrementCacheSize != null) {
            builder.append(" AUTO_INCREMENT_CACHE_SIZE=").append(this.autoIncrementCacheSize);
        }
        if (this.partitionType != null) {
            builder.append(" PARTITION_TYPE=").append(this.partitionType);
        }
        if (this.externalProperties != null) {
            builder.append(" PROPERTIES=(").append(this.externalProperties.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","))).append(")");
        }
        if (this.lobStorageOption != null) {
            builder.append(" ").append(this.lobStorageOption);
        }
        if (this.microIndexClustered != null) {
            builder.append(" MICRO_INDEX_CLUSTERED=").append(Boolean.TRUE.equals(this.microIndexClustered) ? "TRUE" : "FALSE");
        }
        if (this.autoRefresh != null) {
            builder.append(" AUTO_REFRESH=").append(this.autoRefresh);
        }
        if (this.maxRows != null) {
            builder.append(" MAX_ROWS=").append(this.maxRows);
        }
        if (this.minRows != null) {
            builder.append(" MIN_ROWS=").append(this.minRows);
        }
        if (this.password != null) {
            builder.append(" PASSWORD=").append(this.password);
        }
        if (this.packKeys != null) {
            builder.append(" PACK_KEYS=").append(this.packKeys);
        }
        if (this.connection != null) {
            builder.append(" CONNECTION=").append(this.connection);
        }
        if (this.dataDirectory != null) {
            builder.append(" DATA DIRECTORY=").append(this.dataDirectory);
        }
        if (this.indexDirectory != null) {
            builder.append(" INDEX DIRECTORY=").append(this.indexDirectory);
        }
        if (this.encryption != null) {
            builder.append(" ENCRYPTION=").append(this.encryption);
        }
        if (this.statsAutoRecalc != null) {
            builder.append(" STATS_AUTO_RECALC=").append(this.statsAutoRecalc);
        }
        if (this.statsPersistent != null) {
            builder.append(" STATS_PERSISTENT=").append(this.statsPersistent);
        }
        if (this.statsSamplePages != null) {
            builder.append(" STATS_SAMPLE_PAGES=").append(this.statsSamplePages);
        }
        if (this.union != null) {
            builder.append(" UNION=(").append(this.union.stream().map(RelationFactor::toString).collect(Collectors.joining(", "))).append(")");
        }
        if (this.insertMethod != null) {
            builder.append(" INSERT_METHOD=").append(this.insertMethod);
        }
        if (this.organization != null) {
            builder.append(" ORGANIZATION=").append(this.organization);
        }
        if (this.enableMacroBlockBloomFilter != null) {
            builder.append(" ENABLE_MACRO_BLOCK_BLOOM_FILTER=").append(Boolean.TRUE.equals(this.enableMacroBlockBloomFilter) ? "TRUE" : "FALSE");
        }
        return builder.length() == 0 ? "" : builder.substring(1);
    }

    public List<ColumnReference> getSortKeys() {
        return this.sortKeys;
    }

    public Integer getParallel() {
        return this.parallel;
    }

    public Boolean getNoParallel() {
        return this.noParallel;
    }

    public String getTableMode() {
        return this.tableMode;
    }

    public String getDuplicateScope() {
        return this.duplicateScope;
    }

    public String getLocality() {
        return this.locality;
    }

    public Expression getExpireInfo() {
        return this.expireInfo;
    }

    public Integer getProgressiveMergeNum() {
        return this.progressiveMergeNum;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public Integer getTableId() {
        return this.tableId;
    }

    public Integer getReplicaNum() {
        return this.replicaNum;
    }

    public Boolean getNoCompress() {
        return this.noCompress;
    }

    public String getCompress() {
        return this.compress;
    }

    public Boolean getUseBloomFilter() {
        return this.useBloomFilter;
    }

    public String getPrimaryZone() {
        return this.primaryZone;
    }

    public String getTableGroup() {
        return this.tableGroup;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Boolean getReadWrite() {
        return this.readWrite;
    }

    public String getEngine() {
        return this.engine;
    }

    public Integer getTabletSize() {
        return this.tabletSize;
    }

    public Integer getMaxUsedPartId() {
        return this.maxUsedPartId;
    }

    public Boolean getEnableRowMovement() {
        return this.enableRowMovement;
    }

    public Boolean getDisableRowMovement() {
        return this.disableRowMovement;
    }

    public Integer getPctFree() {
        return this.pctFree;
    }

    public Integer getPctUsed() {
        return this.pctUsed;
    }

    public Integer getIniTrans() {
        return this.iniTrans;
    }

    public Integer getMaxTrans() {
        return this.maxTrans;
    }

    public List<String> getStorage() {
        return this.storage;
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCompression() {
        return this.compression;
    }

    public Integer getStorageFormatVersion() {
        return this.storageFormatVersion;
    }

    public String getRowFormat() {
        return this.rowFormat;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCollation() {
        return this.collation;
    }

    public BigDecimal getAutoIncrement() {
        return this.autoIncrement;
    }

    public Integer getDelayKeyWrite() {
        return this.delayKeyWrite;
    }

    public Integer getAvgRowLength() {
        return this.avgRowLength;
    }

    public Integer getChecksum() {
        return this.checksum;
    }

    public String getAutoIncrementMode() {
        return this.autoIncrementMode;
    }

    public Boolean getEnableExtendedRowId() {
        return this.enableExtendedRowId;
    }

    public String getLocation() {
        return this.location;
    }

    public Map<String, Expression> getFormat() {
        return this.format;
    }

    public String getPattern() {
        return this.pattern;
    }

    public List<Expression> getTtls() {
        return this.ttls;
    }

    public String getKvAttributes() {
        return this.kvAttributes;
    }

    public Integer getDefaultLobInRowThreshold() {
        return this.defaultLobInRowThreshold;
    }

    public Integer getLobInRowThreshold() {
        return this.lobInRowThreshold;
    }

    public Integer getKeyBlockSize() {
        return this.keyBlockSize;
    }

    public Integer getAutoIncrementCacheSize() {
        return this.autoIncrementCacheSize;
    }

    public String getPartitionType() {
        return this.partitionType;
    }

    public Map<String, String> getExternalProperties() {
        return this.externalProperties;
    }

    public LobStorageOption getLobStorageOption() {
        return this.lobStorageOption;
    }

    public Boolean getMicroIndexClustered() {
        return this.microIndexClustered;
    }

    public String getAutoRefresh() {
        return this.autoRefresh;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public Integer getMinRows() {
        return this.minRows;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPackKeys() {
        return this.packKeys;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public String getStatsAutoRecalc() {
        return this.statsAutoRecalc;
    }

    public String getStatsPersistent() {
        return this.statsPersistent;
    }

    public String getStatsSamplePages() {
        return this.statsSamplePages;
    }

    public List<RelationFactor> getUnion() {
        return this.union;
    }

    public String getInsertMethod() {
        return this.insertMethod;
    }

    public String getOrganization() {
        return this.organization;
    }

    public Boolean getEnableMacroBlockBloomFilter() {
        return this.enableMacroBlockBloomFilter;
    }

    public void setSortKeys(List<ColumnReference> sortKeys) {
        this.sortKeys = sortKeys;
    }

    public void setParallel(Integer parallel) {
        this.parallel = parallel;
    }

    public void setNoParallel(Boolean noParallel) {
        this.noParallel = noParallel;
    }

    public void setTableMode(String tableMode) {
        this.tableMode = tableMode;
    }

    public void setDuplicateScope(String duplicateScope) {
        this.duplicateScope = duplicateScope;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public void setExpireInfo(Expression expireInfo) {
        this.expireInfo = expireInfo;
    }

    public void setProgressiveMergeNum(Integer progressiveMergeNum) {
        this.progressiveMergeNum = progressiveMergeNum;
    }

    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    public void setTableId(Integer tableId) {
        this.tableId = tableId;
    }

    public void setReplicaNum(Integer replicaNum) {
        this.replicaNum = replicaNum;
    }

    public void setNoCompress(Boolean noCompress) {
        this.noCompress = noCompress;
    }

    public void setCompress(String compress) {
        this.compress = compress;
    }

    public void setUseBloomFilter(Boolean useBloomFilter) {
        this.useBloomFilter = useBloomFilter;
    }

    public void setPrimaryZone(String primaryZone) {
        this.primaryZone = primaryZone;
    }

    public void setTableGroup(String tableGroup) {
        this.tableGroup = tableGroup;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setReadWrite(Boolean readWrite) {
        this.readWrite = readWrite;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public void setTabletSize(Integer tabletSize) {
        this.tabletSize = tabletSize;
    }

    public void setMaxUsedPartId(Integer maxUsedPartId) {
        this.maxUsedPartId = maxUsedPartId;
    }

    public void setEnableRowMovement(Boolean enableRowMovement) {
        this.enableRowMovement = enableRowMovement;
    }

    public void setDisableRowMovement(Boolean disableRowMovement) {
        this.disableRowMovement = disableRowMovement;
    }

    public void setPctFree(Integer pctFree) {
        this.pctFree = pctFree;
    }

    public void setPctUsed(Integer pctUsed) {
        this.pctUsed = pctUsed;
    }

    public void setIniTrans(Integer iniTrans) {
        this.iniTrans = iniTrans;
    }

    public void setMaxTrans(Integer maxTrans) {
        this.maxTrans = maxTrans;
    }

    public void setStorage(List<String> storage) {
        this.storage = storage;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public void setStorageFormatVersion(Integer storageFormatVersion) {
        this.storageFormatVersion = storageFormatVersion;
    }

    public void setRowFormat(String rowFormat) {
        this.rowFormat = rowFormat;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setCollation(String collation) {
        this.collation = collation;
    }

    public void setAutoIncrement(BigDecimal autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setDelayKeyWrite(Integer delayKeyWrite) {
        this.delayKeyWrite = delayKeyWrite;
    }

    public void setAvgRowLength(Integer avgRowLength) {
        this.avgRowLength = avgRowLength;
    }

    public void setChecksum(Integer checksum) {
        this.checksum = checksum;
    }

    public void setAutoIncrementMode(String autoIncrementMode) {
        this.autoIncrementMode = autoIncrementMode;
    }

    public void setEnableExtendedRowId(Boolean enableExtendedRowId) {
        this.enableExtendedRowId = enableExtendedRowId;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setFormat(Map<String, Expression> format) {
        this.format = format;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setTtls(List<Expression> ttls) {
        this.ttls = ttls;
    }

    public void setKvAttributes(String kvAttributes) {
        this.kvAttributes = kvAttributes;
    }

    public void setDefaultLobInRowThreshold(Integer defaultLobInRowThreshold) {
        this.defaultLobInRowThreshold = defaultLobInRowThreshold;
    }

    public void setLobInRowThreshold(Integer lobInRowThreshold) {
        this.lobInRowThreshold = lobInRowThreshold;
    }

    public void setKeyBlockSize(Integer keyBlockSize) {
        this.keyBlockSize = keyBlockSize;
    }

    public void setAutoIncrementCacheSize(Integer autoIncrementCacheSize) {
        this.autoIncrementCacheSize = autoIncrementCacheSize;
    }

    public void setPartitionType(String partitionType) {
        this.partitionType = partitionType;
    }

    public void setExternalProperties(Map<String, String> externalProperties) {
        this.externalProperties = externalProperties;
    }

    public void setLobStorageOption(LobStorageOption lobStorageOption) {
        this.lobStorageOption = lobStorageOption;
    }

    public void setMicroIndexClustered(Boolean microIndexClustered) {
        this.microIndexClustered = microIndexClustered;
    }

    public void setAutoRefresh(String autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public void setMinRows(Integer minRows) {
        this.minRows = minRows;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPackKeys(String packKeys) {
        this.packKeys = packKeys;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public void setIndexDirectory(String indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public void setEncryption(String encryption) {
        this.encryption = encryption;
    }

    public void setStatsAutoRecalc(String statsAutoRecalc) {
        this.statsAutoRecalc = statsAutoRecalc;
    }

    public void setStatsPersistent(String statsPersistent) {
        this.statsPersistent = statsPersistent;
    }

    public void setStatsSamplePages(String statsSamplePages) {
        this.statsSamplePages = statsSamplePages;
    }

    public void setUnion(List<RelationFactor> union) {
        this.union = union;
    }

    public void setInsertMethod(String insertMethod) {
        this.insertMethod = insertMethod;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setEnableMacroBlockBloomFilter(Boolean enableMacroBlockBloomFilter) {
        this.enableMacroBlockBloomFilter = enableMacroBlockBloomFilter;
    }

    public TableOptions() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableOptions)) {
            return false;
        }
        TableOptions other = (TableOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ColumnReference> this$sortKeys = this.getSortKeys();
        List<ColumnReference> other$sortKeys = other.getSortKeys();
        if (this$sortKeys == null ? other$sortKeys != null : !((Object)this$sortKeys).equals(other$sortKeys)) {
            return false;
        }
        Integer this$parallel = this.getParallel();
        Integer other$parallel = other.getParallel();
        if (this$parallel == null ? other$parallel != null : !((Object)this$parallel).equals(other$parallel)) {
            return false;
        }
        Boolean this$noParallel = this.getNoParallel();
        Boolean other$noParallel = other.getNoParallel();
        if (this$noParallel == null ? other$noParallel != null : !((Object)this$noParallel).equals(other$noParallel)) {
            return false;
        }
        String this$tableMode = this.getTableMode();
        String other$tableMode = other.getTableMode();
        if (this$tableMode == null ? other$tableMode != null : !this$tableMode.equals(other$tableMode)) {
            return false;
        }
        String this$duplicateScope = this.getDuplicateScope();
        String other$duplicateScope = other.getDuplicateScope();
        if (this$duplicateScope == null ? other$duplicateScope != null : !this$duplicateScope.equals(other$duplicateScope)) {
            return false;
        }
        String this$locality = this.getLocality();
        String other$locality = other.getLocality();
        if (this$locality == null ? other$locality != null : !this$locality.equals(other$locality)) {
            return false;
        }
        Expression this$expireInfo = this.getExpireInfo();
        Expression other$expireInfo = other.getExpireInfo();
        if (this$expireInfo == null ? other$expireInfo != null : !this$expireInfo.equals(other$expireInfo)) {
            return false;
        }
        Integer this$progressiveMergeNum = this.getProgressiveMergeNum();
        Integer other$progressiveMergeNum = other.getProgressiveMergeNum();
        if (this$progressiveMergeNum == null ? other$progressiveMergeNum != null : !((Object)this$progressiveMergeNum).equals(other$progressiveMergeNum)) {
            return false;
        }
        Integer this$blockSize = this.getBlockSize();
        Integer other$blockSize = other.getBlockSize();
        if (this$blockSize == null ? other$blockSize != null : !((Object)this$blockSize).equals(other$blockSize)) {
            return false;
        }
        Integer this$tableId = this.getTableId();
        Integer other$tableId = other.getTableId();
        if (this$tableId == null ? other$tableId != null : !((Object)this$tableId).equals(other$tableId)) {
            return false;
        }
        Integer this$replicaNum = this.getReplicaNum();
        Integer other$replicaNum = other.getReplicaNum();
        if (this$replicaNum == null ? other$replicaNum != null : !((Object)this$replicaNum).equals(other$replicaNum)) {
            return false;
        }
        Boolean this$noCompress = this.getNoCompress();
        Boolean other$noCompress = other.getNoCompress();
        if (this$noCompress == null ? other$noCompress != null : !((Object)this$noCompress).equals(other$noCompress)) {
            return false;
        }
        String this$compress = this.getCompress();
        String other$compress = other.getCompress();
        if (this$compress == null ? other$compress != null : !this$compress.equals(other$compress)) {
            return false;
        }
        Boolean this$useBloomFilter = this.getUseBloomFilter();
        Boolean other$useBloomFilter = other.getUseBloomFilter();
        if (this$useBloomFilter == null ? other$useBloomFilter != null : !((Object)this$useBloomFilter).equals(other$useBloomFilter)) {
            return false;
        }
        String this$primaryZone = this.getPrimaryZone();
        String other$primaryZone = other.getPrimaryZone();
        if (this$primaryZone == null ? other$primaryZone != null : !this$primaryZone.equals(other$primaryZone)) {
            return false;
        }
        String this$tableGroup = this.getTableGroup();
        String other$tableGroup = other.getTableGroup();
        if (this$tableGroup == null ? other$tableGroup != null : !this$tableGroup.equals(other$tableGroup)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        Boolean this$readWrite = this.getReadWrite();
        Boolean other$readWrite = other.getReadWrite();
        if (this$readWrite == null ? other$readWrite != null : !((Object)this$readWrite).equals(other$readWrite)) {
            return false;
        }
        String this$engine = this.getEngine();
        String other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        Integer this$tabletSize = this.getTabletSize();
        Integer other$tabletSize = other.getTabletSize();
        if (this$tabletSize == null ? other$tabletSize != null : !((Object)this$tabletSize).equals(other$tabletSize)) {
            return false;
        }
        Integer this$maxUsedPartId = this.getMaxUsedPartId();
        Integer other$maxUsedPartId = other.getMaxUsedPartId();
        if (this$maxUsedPartId == null ? other$maxUsedPartId != null : !((Object)this$maxUsedPartId).equals(other$maxUsedPartId)) {
            return false;
        }
        Boolean this$enableRowMovement = this.getEnableRowMovement();
        Boolean other$enableRowMovement = other.getEnableRowMovement();
        if (this$enableRowMovement == null ? other$enableRowMovement != null : !((Object)this$enableRowMovement).equals(other$enableRowMovement)) {
            return false;
        }
        Boolean this$disableRowMovement = this.getDisableRowMovement();
        Boolean other$disableRowMovement = other.getDisableRowMovement();
        if (this$disableRowMovement == null ? other$disableRowMovement != null : !((Object)this$disableRowMovement).equals(other$disableRowMovement)) {
            return false;
        }
        Integer this$pctFree = this.getPctFree();
        Integer other$pctFree = other.getPctFree();
        if (this$pctFree == null ? other$pctFree != null : !((Object)this$pctFree).equals(other$pctFree)) {
            return false;
        }
        Integer this$pctUsed = this.getPctUsed();
        Integer other$pctUsed = other.getPctUsed();
        if (this$pctUsed == null ? other$pctUsed != null : !((Object)this$pctUsed).equals(other$pctUsed)) {
            return false;
        }
        Integer this$iniTrans = this.getIniTrans();
        Integer other$iniTrans = other.getIniTrans();
        if (this$iniTrans == null ? other$iniTrans != null : !((Object)this$iniTrans).equals(other$iniTrans)) {
            return false;
        }
        Integer this$maxTrans = this.getMaxTrans();
        Integer other$maxTrans = other.getMaxTrans();
        if (this$maxTrans == null ? other$maxTrans != null : !((Object)this$maxTrans).equals(other$maxTrans)) {
            return false;
        }
        List<String> this$storage = this.getStorage();
        List<String> other$storage = other.getStorage();
        if (this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage)) {
            return false;
        }
        String this$tableSpace = this.getTableSpace();
        String other$tableSpace = other.getTableSpace();
        if (this$tableSpace == null ? other$tableSpace != null : !this$tableSpace.equals(other$tableSpace)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$compression = this.getCompression();
        String other$compression = other.getCompression();
        if (this$compression == null ? other$compression != null : !this$compression.equals(other$compression)) {
            return false;
        }
        Integer this$storageFormatVersion = this.getStorageFormatVersion();
        Integer other$storageFormatVersion = other.getStorageFormatVersion();
        if (this$storageFormatVersion == null ? other$storageFormatVersion != null : !((Object)this$storageFormatVersion).equals(other$storageFormatVersion)) {
            return false;
        }
        String this$rowFormat = this.getRowFormat();
        String other$rowFormat = other.getRowFormat();
        if (this$rowFormat == null ? other$rowFormat != null : !this$rowFormat.equals(other$rowFormat)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        String this$collation = this.getCollation();
        String other$collation = other.getCollation();
        if (this$collation == null ? other$collation != null : !this$collation.equals(other$collation)) {
            return false;
        }
        BigDecimal this$autoIncrement = this.getAutoIncrement();
        BigDecimal other$autoIncrement = other.getAutoIncrement();
        if (this$autoIncrement == null ? other$autoIncrement != null : !((Object)this$autoIncrement).equals(other$autoIncrement)) {
            return false;
        }
        Integer this$delayKeyWrite = this.getDelayKeyWrite();
        Integer other$delayKeyWrite = other.getDelayKeyWrite();
        if (this$delayKeyWrite == null ? other$delayKeyWrite != null : !((Object)this$delayKeyWrite).equals(other$delayKeyWrite)) {
            return false;
        }
        Integer this$avgRowLength = this.getAvgRowLength();
        Integer other$avgRowLength = other.getAvgRowLength();
        if (this$avgRowLength == null ? other$avgRowLength != null : !((Object)this$avgRowLength).equals(other$avgRowLength)) {
            return false;
        }
        Integer this$checksum = this.getChecksum();
        Integer other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !((Object)this$checksum).equals(other$checksum)) {
            return false;
        }
        String this$autoIncrementMode = this.getAutoIncrementMode();
        String other$autoIncrementMode = other.getAutoIncrementMode();
        if (this$autoIncrementMode == null ? other$autoIncrementMode != null : !this$autoIncrementMode.equals(other$autoIncrementMode)) {
            return false;
        }
        Boolean this$enableExtendedRowId = this.getEnableExtendedRowId();
        Boolean other$enableExtendedRowId = other.getEnableExtendedRowId();
        if (this$enableExtendedRowId == null ? other$enableExtendedRowId != null : !((Object)this$enableExtendedRowId).equals(other$enableExtendedRowId)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        Map<String, Expression> this$format = this.getFormat();
        Map<String, Expression> other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)this$format).equals(other$format)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        List<Expression> this$ttls = this.getTtls();
        List<Expression> other$ttls = other.getTtls();
        if (this$ttls == null ? other$ttls != null : !((Object)this$ttls).equals(other$ttls)) {
            return false;
        }
        String this$kvAttributes = this.getKvAttributes();
        String other$kvAttributes = other.getKvAttributes();
        if (this$kvAttributes == null ? other$kvAttributes != null : !this$kvAttributes.equals(other$kvAttributes)) {
            return false;
        }
        Integer this$defaultLobInRowThreshold = this.getDefaultLobInRowThreshold();
        Integer other$defaultLobInRowThreshold = other.getDefaultLobInRowThreshold();
        if (this$defaultLobInRowThreshold == null ? other$defaultLobInRowThreshold != null : !((Object)this$defaultLobInRowThreshold).equals(other$defaultLobInRowThreshold)) {
            return false;
        }
        Integer this$lobInRowThreshold = this.getLobInRowThreshold();
        Integer other$lobInRowThreshold = other.getLobInRowThreshold();
        if (this$lobInRowThreshold == null ? other$lobInRowThreshold != null : !((Object)this$lobInRowThreshold).equals(other$lobInRowThreshold)) {
            return false;
        }
        Integer this$keyBlockSize = this.getKeyBlockSize();
        Integer other$keyBlockSize = other.getKeyBlockSize();
        if (this$keyBlockSize == null ? other$keyBlockSize != null : !((Object)this$keyBlockSize).equals(other$keyBlockSize)) {
            return false;
        }
        Integer this$autoIncrementCacheSize = this.getAutoIncrementCacheSize();
        Integer other$autoIncrementCacheSize = other.getAutoIncrementCacheSize();
        if (this$autoIncrementCacheSize == null ? other$autoIncrementCacheSize != null : !((Object)this$autoIncrementCacheSize).equals(other$autoIncrementCacheSize)) {
            return false;
        }
        String this$partitionType = this.getPartitionType();
        String other$partitionType = other.getPartitionType();
        if (this$partitionType == null ? other$partitionType != null : !this$partitionType.equals(other$partitionType)) {
            return false;
        }
        Map<String, String> this$externalProperties = this.getExternalProperties();
        Map<String, String> other$externalProperties = other.getExternalProperties();
        if (this$externalProperties == null ? other$externalProperties != null : !((Object)this$externalProperties).equals(other$externalProperties)) {
            return false;
        }
        LobStorageOption this$lobStorageOption = this.getLobStorageOption();
        LobStorageOption other$lobStorageOption = other.getLobStorageOption();
        if (this$lobStorageOption == null ? other$lobStorageOption != null : !((Object)this$lobStorageOption).equals(other$lobStorageOption)) {
            return false;
        }
        Boolean this$microIndexClustered = this.getMicroIndexClustered();
        Boolean other$microIndexClustered = other.getMicroIndexClustered();
        if (this$microIndexClustered == null ? other$microIndexClustered != null : !((Object)this$microIndexClustered).equals(other$microIndexClustered)) {
            return false;
        }
        String this$autoRefresh = this.getAutoRefresh();
        String other$autoRefresh = other.getAutoRefresh();
        if (this$autoRefresh == null ? other$autoRefresh != null : !this$autoRefresh.equals(other$autoRefresh)) {
            return false;
        }
        Integer this$maxRows = this.getMaxRows();
        Integer other$maxRows = other.getMaxRows();
        if (this$maxRows == null ? other$maxRows != null : !((Object)this$maxRows).equals(other$maxRows)) {
            return false;
        }
        Integer this$minRows = this.getMinRows();
        Integer other$minRows = other.getMinRows();
        if (this$minRows == null ? other$minRows != null : !((Object)this$minRows).equals(other$minRows)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$packKeys = this.getPackKeys();
        String other$packKeys = other.getPackKeys();
        if (this$packKeys == null ? other$packKeys != null : !this$packKeys.equals(other$packKeys)) {
            return false;
        }
        String this$connection = this.getConnection();
        String other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) {
            return false;
        }
        String this$dataDirectory = this.getDataDirectory();
        String other$dataDirectory = other.getDataDirectory();
        if (this$dataDirectory == null ? other$dataDirectory != null : !this$dataDirectory.equals(other$dataDirectory)) {
            return false;
        }
        String this$indexDirectory = this.getIndexDirectory();
        String other$indexDirectory = other.getIndexDirectory();
        if (this$indexDirectory == null ? other$indexDirectory != null : !this$indexDirectory.equals(other$indexDirectory)) {
            return false;
        }
        String this$encryption = this.getEncryption();
        String other$encryption = other.getEncryption();
        if (this$encryption == null ? other$encryption != null : !this$encryption.equals(other$encryption)) {
            return false;
        }
        String this$statsAutoRecalc = this.getStatsAutoRecalc();
        String other$statsAutoRecalc = other.getStatsAutoRecalc();
        if (this$statsAutoRecalc == null ? other$statsAutoRecalc != null : !this$statsAutoRecalc.equals(other$statsAutoRecalc)) {
            return false;
        }
        String this$statsPersistent = this.getStatsPersistent();
        String other$statsPersistent = other.getStatsPersistent();
        if (this$statsPersistent == null ? other$statsPersistent != null : !this$statsPersistent.equals(other$statsPersistent)) {
            return false;
        }
        String this$statsSamplePages = this.getStatsSamplePages();
        String other$statsSamplePages = other.getStatsSamplePages();
        if (this$statsSamplePages == null ? other$statsSamplePages != null : !this$statsSamplePages.equals(other$statsSamplePages)) {
            return false;
        }
        List<RelationFactor> this$union = this.getUnion();
        List<RelationFactor> other$union = other.getUnion();
        if (this$union == null ? other$union != null : !((Object)this$union).equals(other$union)) {
            return false;
        }
        String this$insertMethod = this.getInsertMethod();
        String other$insertMethod = other.getInsertMethod();
        if (this$insertMethod == null ? other$insertMethod != null : !this$insertMethod.equals(other$insertMethod)) {
            return false;
        }
        String this$organization = this.getOrganization();
        String other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        Boolean this$enableMacroBlockBloomFilter = this.getEnableMacroBlockBloomFilter();
        Boolean other$enableMacroBlockBloomFilter = other.getEnableMacroBlockBloomFilter();
        return !(this$enableMacroBlockBloomFilter == null ? other$enableMacroBlockBloomFilter != null : !((Object)this$enableMacroBlockBloomFilter).equals(other$enableMacroBlockBloomFilter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ColumnReference> $sortKeys = this.getSortKeys();
        result = result * 59 + ($sortKeys == null ? 43 : ((Object)$sortKeys).hashCode());
        Integer $parallel = this.getParallel();
        result = result * 59 + ($parallel == null ? 43 : ((Object)$parallel).hashCode());
        Boolean $noParallel = this.getNoParallel();
        result = result * 59 + ($noParallel == null ? 43 : ((Object)$noParallel).hashCode());
        String $tableMode = this.getTableMode();
        result = result * 59 + ($tableMode == null ? 43 : $tableMode.hashCode());
        String $duplicateScope = this.getDuplicateScope();
        result = result * 59 + ($duplicateScope == null ? 43 : $duplicateScope.hashCode());
        String $locality = this.getLocality();
        result = result * 59 + ($locality == null ? 43 : $locality.hashCode());
        Expression $expireInfo = this.getExpireInfo();
        result = result * 59 + ($expireInfo == null ? 43 : $expireInfo.hashCode());
        Integer $progressiveMergeNum = this.getProgressiveMergeNum();
        result = result * 59 + ($progressiveMergeNum == null ? 43 : ((Object)$progressiveMergeNum).hashCode());
        Integer $blockSize = this.getBlockSize();
        result = result * 59 + ($blockSize == null ? 43 : ((Object)$blockSize).hashCode());
        Integer $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : ((Object)$tableId).hashCode());
        Integer $replicaNum = this.getReplicaNum();
        result = result * 59 + ($replicaNum == null ? 43 : ((Object)$replicaNum).hashCode());
        Boolean $noCompress = this.getNoCompress();
        result = result * 59 + ($noCompress == null ? 43 : ((Object)$noCompress).hashCode());
        String $compress = this.getCompress();
        result = result * 59 + ($compress == null ? 43 : $compress.hashCode());
        Boolean $useBloomFilter = this.getUseBloomFilter();
        result = result * 59 + ($useBloomFilter == null ? 43 : ((Object)$useBloomFilter).hashCode());
        String $primaryZone = this.getPrimaryZone();
        result = result * 59 + ($primaryZone == null ? 43 : $primaryZone.hashCode());
        String $tableGroup = this.getTableGroup();
        result = result * 59 + ($tableGroup == null ? 43 : $tableGroup.hashCode());
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        Boolean $readWrite = this.getReadWrite();
        result = result * 59 + ($readWrite == null ? 43 : ((Object)$readWrite).hashCode());
        String $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        Integer $tabletSize = this.getTabletSize();
        result = result * 59 + ($tabletSize == null ? 43 : ((Object)$tabletSize).hashCode());
        Integer $maxUsedPartId = this.getMaxUsedPartId();
        result = result * 59 + ($maxUsedPartId == null ? 43 : ((Object)$maxUsedPartId).hashCode());
        Boolean $enableRowMovement = this.getEnableRowMovement();
        result = result * 59 + ($enableRowMovement == null ? 43 : ((Object)$enableRowMovement).hashCode());
        Boolean $disableRowMovement = this.getDisableRowMovement();
        result = result * 59 + ($disableRowMovement == null ? 43 : ((Object)$disableRowMovement).hashCode());
        Integer $pctFree = this.getPctFree();
        result = result * 59 + ($pctFree == null ? 43 : ((Object)$pctFree).hashCode());
        Integer $pctUsed = this.getPctUsed();
        result = result * 59 + ($pctUsed == null ? 43 : ((Object)$pctUsed).hashCode());
        Integer $iniTrans = this.getIniTrans();
        result = result * 59 + ($iniTrans == null ? 43 : ((Object)$iniTrans).hashCode());
        Integer $maxTrans = this.getMaxTrans();
        result = result * 59 + ($maxTrans == null ? 43 : ((Object)$maxTrans).hashCode());
        List<String> $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        String $tableSpace = this.getTableSpace();
        result = result * 59 + ($tableSpace == null ? 43 : $tableSpace.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $compression = this.getCompression();
        result = result * 59 + ($compression == null ? 43 : $compression.hashCode());
        Integer $storageFormatVersion = this.getStorageFormatVersion();
        result = result * 59 + ($storageFormatVersion == null ? 43 : ((Object)$storageFormatVersion).hashCode());
        String $rowFormat = this.getRowFormat();
        result = result * 59 + ($rowFormat == null ? 43 : $rowFormat.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        String $collation = this.getCollation();
        result = result * 59 + ($collation == null ? 43 : $collation.hashCode());
        BigDecimal $autoIncrement = this.getAutoIncrement();
        result = result * 59 + ($autoIncrement == null ? 43 : ((Object)$autoIncrement).hashCode());
        Integer $delayKeyWrite = this.getDelayKeyWrite();
        result = result * 59 + ($delayKeyWrite == null ? 43 : ((Object)$delayKeyWrite).hashCode());
        Integer $avgRowLength = this.getAvgRowLength();
        result = result * 59 + ($avgRowLength == null ? 43 : ((Object)$avgRowLength).hashCode());
        Integer $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : ((Object)$checksum).hashCode());
        String $autoIncrementMode = this.getAutoIncrementMode();
        result = result * 59 + ($autoIncrementMode == null ? 43 : $autoIncrementMode.hashCode());
        Boolean $enableExtendedRowId = this.getEnableExtendedRowId();
        result = result * 59 + ($enableExtendedRowId == null ? 43 : ((Object)$enableExtendedRowId).hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        Map<String, Expression> $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        List<Expression> $ttls = this.getTtls();
        result = result * 59 + ($ttls == null ? 43 : ((Object)$ttls).hashCode());
        String $kvAttributes = this.getKvAttributes();
        result = result * 59 + ($kvAttributes == null ? 43 : $kvAttributes.hashCode());
        Integer $defaultLobInRowThreshold = this.getDefaultLobInRowThreshold();
        result = result * 59 + ($defaultLobInRowThreshold == null ? 43 : ((Object)$defaultLobInRowThreshold).hashCode());
        Integer $lobInRowThreshold = this.getLobInRowThreshold();
        result = result * 59 + ($lobInRowThreshold == null ? 43 : ((Object)$lobInRowThreshold).hashCode());
        Integer $keyBlockSize = this.getKeyBlockSize();
        result = result * 59 + ($keyBlockSize == null ? 43 : ((Object)$keyBlockSize).hashCode());
        Integer $autoIncrementCacheSize = this.getAutoIncrementCacheSize();
        result = result * 59 + ($autoIncrementCacheSize == null ? 43 : ((Object)$autoIncrementCacheSize).hashCode());
        String $partitionType = this.getPartitionType();
        result = result * 59 + ($partitionType == null ? 43 : $partitionType.hashCode());
        Map<String, String> $externalProperties = this.getExternalProperties();
        result = result * 59 + ($externalProperties == null ? 43 : ((Object)$externalProperties).hashCode());
        LobStorageOption $lobStorageOption = this.getLobStorageOption();
        result = result * 59 + ($lobStorageOption == null ? 43 : ((Object)$lobStorageOption).hashCode());
        Boolean $microIndexClustered = this.getMicroIndexClustered();
        result = result * 59 + ($microIndexClustered == null ? 43 : ((Object)$microIndexClustered).hashCode());
        String $autoRefresh = this.getAutoRefresh();
        result = result * 59 + ($autoRefresh == null ? 43 : $autoRefresh.hashCode());
        Integer $maxRows = this.getMaxRows();
        result = result * 59 + ($maxRows == null ? 43 : ((Object)$maxRows).hashCode());
        Integer $minRows = this.getMinRows();
        result = result * 59 + ($minRows == null ? 43 : ((Object)$minRows).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $packKeys = this.getPackKeys();
        result = result * 59 + ($packKeys == null ? 43 : $packKeys.hashCode());
        String $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
        String $dataDirectory = this.getDataDirectory();
        result = result * 59 + ($dataDirectory == null ? 43 : $dataDirectory.hashCode());
        String $indexDirectory = this.getIndexDirectory();
        result = result * 59 + ($indexDirectory == null ? 43 : $indexDirectory.hashCode());
        String $encryption = this.getEncryption();
        result = result * 59 + ($encryption == null ? 43 : $encryption.hashCode());
        String $statsAutoRecalc = this.getStatsAutoRecalc();
        result = result * 59 + ($statsAutoRecalc == null ? 43 : $statsAutoRecalc.hashCode());
        String $statsPersistent = this.getStatsPersistent();
        result = result * 59 + ($statsPersistent == null ? 43 : $statsPersistent.hashCode());
        String $statsSamplePages = this.getStatsSamplePages();
        result = result * 59 + ($statsSamplePages == null ? 43 : $statsSamplePages.hashCode());
        List<RelationFactor> $union = this.getUnion();
        result = result * 59 + ($union == null ? 43 : ((Object)$union).hashCode());
        String $insertMethod = this.getInsertMethod();
        result = result * 59 + ($insertMethod == null ? 43 : $insertMethod.hashCode());
        String $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        Boolean $enableMacroBlockBloomFilter = this.getEnableMacroBlockBloomFilter();
        result = result * 59 + ($enableMacroBlockBloomFilter == null ? 43 : ((Object)$enableMacroBlockBloomFilter).hashCode());
        return result;
    }
}

