/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.sqlparser.statement.droptable;

import com.oceanbase.tools.sqlparser.statement.BaseStatement;
import com.oceanbase.tools.sqlparser.statement.common.RelationFactor;
import com.oceanbase.tools.sqlparser.statement.droptable.TableList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.lang3.StringUtils;

public class DropTable
extends BaseStatement {
    private boolean temporary;
    private boolean materialized;
    private boolean ifExists;
    private boolean cascade;
    private boolean cascadeConstraints;
    private boolean restrict;
    private boolean purge;
    private TableList tableList;
    private final List<RelationFactor> relations;

    public DropTable(@NonNull ParserRuleContext context, @NonNull TableList tableList, boolean temporary, boolean materialized, boolean ifExists, boolean cascade, boolean restrict) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (tableList == null) {
            throw new NullPointerException("tableList is marked non-null but is null");
        }
        this.tableList = tableList;
        this.relations = tableList.getRelations();
        this.temporary = temporary;
        this.materialized = materialized;
        this.ifExists = ifExists;
        this.cascade = cascade;
        this.restrict = restrict;
    }

    public DropTable(@NonNull ParserRuleContext context, @NonNull RelationFactor relation, boolean cascadeConstraints, boolean purge) {
        super(context);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (relation == null) {
            throw new NullPointerException("relation is marked non-null but is null");
        }
        this.relations = Collections.singletonList(relation);
        this.cascadeConstraints = cascadeConstraints;
        this.purge = purge;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DROP ");
        if (this.temporary) {
            sb.append("TEMPORARY ");
        }
        if (this.materialized) {
            sb.append("MATERIALIZED ");
        }
        sb.append("TABLE ");
        if (this.ifExists) {
            sb.append("IF EXISTS ");
        }
        if (this.relations != null) {
            sb.append(StringUtils.join(this.relations, (char)','));
        }
        if (this.cascade) {
            sb.append(" CASCADE ");
        } else if (this.restrict) {
            sb.append(" RESTRICT ");
        }
        if (this.cascadeConstraints) {
            sb.append(" CASCADE CONSTRAINTS ");
        }
        if (this.purge) {
            sb.append(" PURGE");
        }
        return sb.toString();
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isMaterialized() {
        return this.materialized;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public boolean isCascade() {
        return this.cascade;
    }

    public boolean isCascadeConstraints() {
        return this.cascadeConstraints;
    }

    public boolean isRestrict() {
        return this.restrict;
    }

    public boolean isPurge() {
        return this.purge;
    }

    public TableList getTableList() {
        return this.tableList;
    }

    public List<RelationFactor> getRelations() {
        return this.relations;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public void setMaterialized(boolean materialized) {
        this.materialized = materialized;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public void setCascade(boolean cascade) {
        this.cascade = cascade;
    }

    public void setCascadeConstraints(boolean cascadeConstraints) {
        this.cascadeConstraints = cascadeConstraints;
    }

    public void setRestrict(boolean restrict) {
        this.restrict = restrict;
    }

    public void setPurge(boolean purge) {
        this.purge = purge;
    }

    public void setTableList(TableList tableList) {
        this.tableList = tableList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DropTable)) {
            return false;
        }
        DropTable other = (DropTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTemporary() != other.isTemporary()) {
            return false;
        }
        if (this.isMaterialized() != other.isMaterialized()) {
            return false;
        }
        if (this.isIfExists() != other.isIfExists()) {
            return false;
        }
        if (this.isCascade() != other.isCascade()) {
            return false;
        }
        if (this.isCascadeConstraints() != other.isCascadeConstraints()) {
            return false;
        }
        if (this.isRestrict() != other.isRestrict()) {
            return false;
        }
        if (this.isPurge() != other.isPurge()) {
            return false;
        }
        TableList this$tableList = this.getTableList();
        TableList other$tableList = other.getTableList();
        if (this$tableList == null ? other$tableList != null : !((Object)this$tableList).equals(other$tableList)) {
            return false;
        }
        List<RelationFactor> this$relations = this.getRelations();
        List<RelationFactor> other$relations = other.getRelations();
        return !(this$relations == null ? other$relations != null : !((Object)this$relations).equals(other$relations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DropTable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTemporary() ? 79 : 97);
        result = result * 59 + (this.isMaterialized() ? 79 : 97);
        result = result * 59 + (this.isIfExists() ? 79 : 97);
        result = result * 59 + (this.isCascade() ? 79 : 97);
        result = result * 59 + (this.isCascadeConstraints() ? 79 : 97);
        result = result * 59 + (this.isRestrict() ? 79 : 97);
        result = result * 59 + (this.isPurge() ? 79 : 97);
        TableList $tableList = this.getTableList();
        result = result * 59 + ($tableList == null ? 43 : ((Object)$tableList).hashCode());
        List<RelationFactor> $relations = this.getRelations();
        result = result * 59 + ($relations == null ? 43 : ((Object)$relations).hashCode());
        return result;
    }
}

